/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.campaign.infra;

import com.chutneytesting.campaign.domain.CampaignExecutionRepository;
import com.chutneytesting.campaign.domain.CampaignNotFoundException;
import com.chutneytesting.campaign.infra.CampaignExecutionJpaRepository;
import com.chutneytesting.campaign.infra.CampaignJpaRepository;
import com.chutneytesting.campaign.infra.jpa.CampaignEntity;
import com.chutneytesting.campaign.infra.jpa.CampaignExecutionEntity;
import com.chutneytesting.execution.domain.campaign.CampaignExecutionNotFoundException;
import com.chutneytesting.execution.infra.storage.DatabaseExecutionJpaRepository;
import com.chutneytesting.execution.infra.storage.jpa.ScenarioExecutionEntity;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadata;
import com.chutneytesting.server.core.domain.scenario.TestCaseRepository;
import com.chutneytesting.server.core.domain.scenario.campaign.CampaignExecution;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(readOnly=true)
public class CampaignExecutionDBRepository
implements CampaignExecutionRepository {
    private final CampaignExecutionJpaRepository campaignExecutionJpaRepository;
    private final CampaignJpaRepository campaignJpaRepository;
    private final DatabaseExecutionJpaRepository scenarioExecutionJpaRepository;
    private final TestCaseRepository testCaseRepository;
    private final Map<Long, CampaignExecution> currentCampaignExecutions = new ConcurrentHashMap<Long, CampaignExecution>();

    public CampaignExecutionDBRepository(CampaignExecutionJpaRepository campaignExecutionJpaRepository, CampaignJpaRepository campaignJpaRepository, DatabaseExecutionJpaRepository scenarioExecutionJpaRepository, TestCaseRepository testCaseRepository) {
        this.campaignExecutionJpaRepository = campaignExecutionJpaRepository;
        this.campaignJpaRepository = campaignJpaRepository;
        this.scenarioExecutionJpaRepository = scenarioExecutionJpaRepository;
        this.testCaseRepository = testCaseRepository;
    }

    @Override
    public Optional<CampaignExecution> currentExecution(Long campaignId) {
        return Optional.ofNullable(campaignId).map(id -> this.currentCampaignExecutions.get(campaignId));
    }

    @Override
    public List<CampaignExecution> currentExecutions() {
        return new ArrayList<CampaignExecution>(this.currentCampaignExecutions.values());
    }

    @Override
    public void startExecution(Long campaignId, CampaignExecution campaignExecution) {
        this.currentCampaignExecutions.put(campaignId, campaignExecution);
    }

    @Override
    public void stopExecution(Long campaignId) {
        this.currentCampaignExecutions.remove(campaignId);
    }

    @Override
    public CampaignExecution getLastExecution(Long campaignId) {
        return this.campaignExecutionJpaRepository.findFirstByCampaignIdOrderByIdDesc(campaignId).map(this::toDomain).orElseThrow(() -> new CampaignExecutionNotFoundException(campaignId));
    }

    @Override
    @Transactional
    public void deleteExecutions(Set<Long> executionsIds) {
        List executions = this.campaignExecutionJpaRepository.findAllById(executionsIds);
        List scenarioExecutions = executions.stream().flatMap(cer -> cer.scenarioExecutions().stream()).toList();
        scenarioExecutions.forEach(ScenarioExecutionEntity::clearCampaignExecution);
        this.scenarioExecutionJpaRepository.saveAll(scenarioExecutions);
        this.campaignExecutionJpaRepository.deleteAllInBatch(executions);
    }

    @Override
    public List<CampaignExecution> getExecutionHistory(Long campaignId) {
        CampaignEntity campaign = (CampaignEntity)this.campaignJpaRepository.findById(campaignId).orElseThrow(() -> new CampaignNotFoundException(campaignId));
        return this.campaignExecutionJpaRepository.findByCampaignIdOrderByIdDesc(campaignId).stream().map(ce -> this.toDomainWithCampaign(campaign, (CampaignExecutionEntity)ce)).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    @Transactional
    public void saveCampaignExecution(Long campaignId, CampaignExecution campaignExecution) {
        CampaignExecutionEntity execution = (CampaignExecutionEntity)this.campaignExecutionJpaRepository.findById(campaignExecution.executionId).orElseThrow(() -> new CampaignExecutionNotFoundException(campaignId, campaignExecution.executionId));
        List scenarioExecutions = this.scenarioExecutionJpaRepository.findAllById(campaignExecution.scenarioExecutionReports().stream().map(serc -> serc.execution.executionId()).toList());
        execution.updateFromDomain(campaignExecution, scenarioExecutions);
        this.campaignExecutionJpaRepository.save(execution);
    }

    @Override
    public List<CampaignExecution> getLastExecutions(Long numberOfExecution) {
        return this.campaignExecutionJpaRepository.findAll((Pageable)PageRequest.of((int)0, (int)numberOfExecution.intValue(), (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"}))).stream().map(this::toDomain).filter(Objects::nonNull).toList();
    }

    @Override
    public CampaignExecution getCampaignExecutionById(Long campaignExecId) {
        return this.campaignExecutionJpaRepository.findById(campaignExecId).map(this::toDomain).orElseThrow(() -> new CampaignExecutionNotFoundException(null, campaignExecId));
    }

    @Override
    @Transactional
    public void clearAllExecutionHistory(Long campaignId) {
        List<CampaignExecutionEntity> campaignExecutionEntities = this.campaignExecutionJpaRepository.findAllByCampaignId(campaignId);
        List scenarioExecutions = campaignExecutionEntities.stream().flatMap(ce -> ce.scenarioExecutions().stream()).toList();
        scenarioExecutions.forEach(ScenarioExecutionEntity::clearCampaignExecution);
        this.scenarioExecutionJpaRepository.saveAll(scenarioExecutions);
        this.campaignExecutionJpaRepository.deleteAllInBatch(campaignExecutionEntities);
    }

    @Override
    @Transactional
    public Long generateCampaignExecutionId(Long campaignId, String environment) {
        Validate.notNull((Object)campaignId, (String)"Campaign ID cannot be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)environment, (String)"Environment cannot be null or empty", (Object[])new Object[0]);
        CampaignExecutionEntity newExecution = new CampaignExecutionEntity(campaignId, environment);
        this.campaignExecutionJpaRepository.save(newExecution);
        return newExecution.id();
    }

    private CampaignExecution toDomain(CampaignExecutionEntity campaignExecution) {
        return this.toDomainWithCampaign((CampaignEntity)this.campaignJpaRepository.findById(campaignExecution.campaignId()).orElseThrow(() -> new CampaignExecutionNotFoundException(campaignExecution.campaignId(), campaignExecution.id())), campaignExecution);
    }

    private CampaignExecution toDomainWithCampaign(CampaignEntity campaign, CampaignExecutionEntity campaignExecutionEntity) {
        return campaignExecutionEntity.toDomain(campaign, this.isCampaignExecutionRunning(campaignExecutionEntity), this::title);
    }

    private String title(String scenarioId) {
        return this.testCaseRepository.findMetadataById(scenarioId).map(TestCaseMetadata::title).orElse("");
    }

    private boolean isCampaignExecutionRunning(CampaignExecutionEntity campaignExecutionEntity) {
        return this.currentExecution(campaignExecutionEntity.campaignId()).map(cer -> cer.executionId.equals(campaignExecutionEntity.id())).orElse(false);
    }
}

