/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.campaign.domain;

import com.chutneytesting.campaign.domain.Frequency;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

public class PeriodicScheduledCampaign {
    public final Long id;
    public final List<Long> campaignsId;
    public final List<String> campaignsTitle;
    public final LocalDateTime nextExecutionDate;
    public final Frequency frequency;

    public PeriodicScheduledCampaign(Long id, List<Long> campaignsId, List<String> campaignsTitle, LocalDateTime nextExecutionDate, Frequency frequency) {
        this.id = id;
        this.campaignsId = campaignsId;
        this.campaignsTitle = campaignsTitle;
        this.nextExecutionDate = nextExecutionDate;
        this.frequency = frequency;
    }

    public PeriodicScheduledCampaign(Long id, List<Long> campaignsId, List<String> campaignsTitle, LocalDateTime nextExecutionDate) {
        this(id, campaignsId, campaignsTitle, nextExecutionDate, Frequency.EMPTY);
    }

    public PeriodicScheduledCampaign(Long id, Long campaignId, String campaignTitle, LocalDateTime nextExecutionDate) {
        this(id, List.of(campaignId), List.of(campaignTitle), nextExecutionDate, Frequency.EMPTY);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PeriodicScheduledCampaign that = (PeriodicScheduledCampaign)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.campaignsId, that.campaignsId) && Objects.equals(this.campaignsTitle, that.campaignsTitle) && Objects.equals(this.nextExecutionDate, that.nextExecutionDate) && Objects.equals((Object)this.frequency, (Object)that.frequency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.campaignsId, this.campaignsTitle, this.nextExecutionDate, this.frequency});
    }

    public String toString() {
        return "SchedulingCampaign{id=" + this.id + ", campaignId=" + this.campaignsId + ", campaignTitle='" + this.campaignsTitle + "', schedulingDate=" + this.nextExecutionDate + ", frequency='" + this.frequency + "'}";
    }

    public PeriodicScheduledCampaign nextScheduledExecution() {
        LocalDateTime scheduledDate = switch (this.frequency) {
            case Frequency.HOURLY -> this.nextExecutionDate.plusHours(1L);
            case Frequency.DAILY -> this.nextExecutionDate.plusDays(1L);
            case Frequency.WEEKLY -> this.nextExecutionDate.plusWeeks(1L);
            case Frequency.MONTHLY -> this.nextExecutionDate.plusMonths(1L);
            default -> throw new IllegalStateException("Unexpected value: " + this.frequency);
        };
        return new PeriodicScheduledCampaign(this.id, this.campaignsId, this.campaignsTitle, scheduledDate, this.frequency);
    }
}

