/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.campaign.api;

import com.chutneytesting.campaign.api.dto.SchedulingCampaignDto;
import com.chutneytesting.campaign.domain.Frequency;
import com.chutneytesting.campaign.domain.PeriodicScheduledCampaign;
import com.chutneytesting.campaign.domain.PeriodicScheduledCampaignRepository;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ui/campaign/v1/scheduling"})
@CrossOrigin(origins={"*"})
public class ScheduleCampaignController {
    private final PeriodicScheduledCampaignRepository periodicScheduledCampaignRepository;

    public ScheduleCampaignController(PeriodicScheduledCampaignRepository periodicScheduledCampaignRepository) {
        this.periodicScheduledCampaignRepository = periodicScheduledCampaignRepository;
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_READ')")
    @GetMapping(path={""}, produces={"application/json"})
    public List<SchedulingCampaignDto> getAll() {
        return this.periodicScheduledCampaignRepository.getAll().stream().map(sc -> new SchedulingCampaignDto(sc.id, sc.campaignsId, sc.campaignsTitle, sc.nextExecutionDate, sc.frequency.label)).sorted(Comparator.comparing(SchedulingCampaignDto::getSchedulingDate)).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_WRITE')")
    @PostMapping(path={""}, consumes={"application/json"}, produces={"application/json"})
    public void add(@RequestBody SchedulingCampaignDto dto) {
        this.periodicScheduledCampaignRepository.add(new PeriodicScheduledCampaign(null, dto.getCampaignsId(), dto.getCampaignsTitle(), dto.getSchedulingDate(), Frequency.toFrequency(dto.getFrequency())));
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_WRITE')")
    @DeleteMapping(path={"/{schedulingCampaignId}"}, produces={"application/json"})
    public void delete(@PathVariable(value="schedulingCampaignId") Long schedulingCampaignId) {
        this.periodicScheduledCampaignRepository.removeById(schedulingCampaignId);
    }
}

