/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.scenario.infra.raw;

import com.chutneytesting.server.core.domain.security.User;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(builder=TestCaseDataBuilder.class)
public class TestCaseData {
    public final String contentVersion;
    public final String id;
    public final String title;
    public final String description;
    public final List<String> tags;
    public final Instant creationDate;
    public final Instant updateDate;
    public final String author;
    public final Integer version;
    public final String defaultDataset;
    public final Map<String, String> executionParameters;
    public final String rawScenario;

    private TestCaseData(String contentVersion, String testCaseId, String title, String description, Instant creationDate, List<String> tags, Map<String, String> executionParameters, String rawScenario, Instant updateDate, String author, Integer version, String defaultDataset) {
        this.contentVersion = contentVersion;
        this.id = testCaseId;
        this.title = title;
        this.description = description;
        this.tags = tags;
        this.creationDate = creationDate;
        this.executionParameters = executionParameters;
        this.rawScenario = rawScenario;
        this.updateDate = updateDate;
        this.author = author;
        this.version = version;
        this.defaultDataset = defaultDataset;
    }

    public String toString() {
        return "TestCaseData{id=" + this.id + ", title='" + this.title + "', description='" + this.description + "', tags=" + this.tags + ", creationDate=" + this.creationDate + ", executionParameters=" + this.executionParameters + ", rawScenario='" + this.rawScenario + "', contentVersion='" + this.contentVersion + "', updateDate='" + this.updateDate + "', author='" + this.author + "', version='" + this.version + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestCaseData that = (TestCaseData)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.title, that.title) && Objects.equals(this.rawScenario, that.rawScenario);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.rawScenario);
    }

    public static TestCaseDataBuilder builder() {
        return new TestCaseDataBuilder();
    }

    @JsonPOJOBuilder
    public static class TestCaseDataBuilder {
        private String contentVersion;
        private String testCaseId;
        private String title;
        private String description;
        private Instant creationDate;
        private List<String> tags;
        private Map<String, String> executionParameters;
        private String rawScenario;
        private Instant updateDate;
        private String author;
        private Integer version;
        private String defaultDataset;

        public TestCaseData build() {
            return new TestCaseData(this.contentVersion, Optional.ofNullable(this.testCaseId).orElseThrow(IllegalArgumentException::new), Optional.ofNullable(this.title).orElse(""), Optional.ofNullable(this.description).orElse(""), Optional.ofNullable(this.creationDate).orElse(Instant.now()), Collections.unmodifiableList(Optional.ofNullable(this.tags).orElse(Collections.emptyList())), Collections.unmodifiableMap(Optional.ofNullable(this.executionParameters).orElse(Collections.emptyMap())), Optional.ofNullable(this.rawScenario).orElse(""), Optional.ofNullable(this.updateDate).orElse(this.creationDate), Optional.ofNullable(this.author).orElseGet(() -> User.ANONYMOUS.id), Optional.ofNullable(this.version).orElse(1), Optional.ofNullable(this.defaultDataset).orElse(""));
        }

        public TestCaseDataBuilder withContentVersion(String contentVersion) {
            this.contentVersion = contentVersion;
            return this;
        }

        public TestCaseDataBuilder withId(String testCaseId) {
            this.testCaseId = testCaseId;
            return this;
        }

        public TestCaseDataBuilder withTitle(String title) {
            this.title = title;
            return this;
        }

        public TestCaseDataBuilder withCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public TestCaseDataBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        public TestCaseDataBuilder withTags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public TestCaseDataBuilder withExecutionParameters(Map<String, String> executionParameters) {
            this.executionParameters = executionParameters;
            return this;
        }

        public TestCaseDataBuilder withRawScenario(String rawScenario) {
            this.rawScenario = rawScenario;
            return this;
        }

        public TestCaseDataBuilder withUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public TestCaseDataBuilder withAuthor(String author) {
            this.author = author;
            return this;
        }

        public TestCaseDataBuilder withVersion(Integer version) {
            this.version = version;
            return this;
        }

        public TestCaseDataBuilder withDefaultDataset(String dataset) {
            this.defaultDataset = dataset;
            return this;
        }

        public static TestCaseDataBuilder from(TestCaseData testCaseData) {
            return TestCaseData.builder().withId(testCaseData.id).withContentVersion(testCaseData.contentVersion).withTitle(testCaseData.title).withDescription(testCaseData.description).withCreationDate(testCaseData.creationDate).withRawScenario(testCaseData.rawScenario).withTags(testCaseData.tags).withExecutionParameters(testCaseData.executionParameters).withAuthor(testCaseData.author).withUpdateDate(testCaseData.updateDate).withVersion(testCaseData.version).withDefaultDataset(testCaseData.defaultDataset);
        }
    }
}

