/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.infra.storage;

import com.chutneytesting.execution.infra.storage.jpa.ScenarioExecutionEntity;
import com.chutneytesting.server.core.domain.execution.report.ServerReportStatus;
import jakarta.persistence.Tuple;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface DatabaseExecutionJpaRepository
extends JpaRepository<ScenarioExecutionEntity, Long>,
JpaSpecificationExecutor<ScenarioExecutionEntity> {
    public List<ScenarioExecutionEntity> findByStatus(ServerReportStatus var1);

    public List<ScenarioExecutionEntity> findByScenarioIdOrderByIdDesc(String var1);

    @Query(value="select max(se.id), se.scenarioId from SCENARIO_EXECUTIONS se where se.scenarioId in :scenarioIds AND se.status != 'NOT_EXECUTED' group by se.scenarioId")
    public List<Tuple> findLastExecutionsByScenarioId(@Param(value="scenarioIds") List<String> var1);

    public List<ScenarioExecutionEntity> findAllByScenarioId(String var1);

    @Query(value="        select se from SCENARIO s, SCENARIO_EXECUTIONS_REPORTS ser\n          inner join ser.scenarioExecution se\n        where s.activated = true\n          and cast(s.id as string) = se.scenarioId\n          and ser.report like '%' || :query || '%'\n        order by se.id desc\n        limit 100\n")
    public List<ScenarioExecutionEntity> getExecutionReportMatchQuery(@Param(value="query") String var1);
}

