/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.design.api.plugins.linkifier;

import com.chutneytesting.design.api.plugins.linkifier.ImmutableLinkifierDto;
import com.chutneytesting.design.api.plugins.linkifier.LinkifierDto;
import com.chutneytesting.design.domain.plugins.linkifier.Linkifier;
import com.chutneytesting.design.domain.plugins.linkifier.Linkifiers;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/ui/plugins/linkifier/"})
@CrossOrigin(origins={"*"})
public class LinkifierController {
    private final Linkifiers linkifiers;

    public LinkifierController(Linkifiers linkifiers) {
        this.linkifiers = linkifiers;
    }

    @GetMapping(produces={"application/json"})
    public List<LinkifierDto> getAllLinkifier() {
        return this.linkifiers.getAll().stream().map(this::toDto).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasAuthority('ADMIN_ACCESS')")
    @PostMapping(consumes={"application/json"}, produces={"application/json"})
    public LinkifierDto saveLinkifier(@RequestBody LinkifierDto linkifierDto) {
        return this.toDto(this.linkifiers.add(new Linkifier(linkifierDto.pattern(), linkifierDto.link(), linkifierDto.id())));
    }

    @PreAuthorize(value="hasAuthority('ADMIN_ACCESS')")
    @DeleteMapping(path={"/{id}"})
    public void removeLinkifier(@PathVariable(value="id") String id) {
        this.linkifiers.remove(id);
    }

    private LinkifierDto toDto(Linkifier linkifier) {
        return ImmutableLinkifierDto.builder().pattern(linkifier.pattern).link(linkifier.link).id(linkifier.id).build();
    }
}

