/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.campaign.infra.jpa;

import com.chutneytesting.campaign.infra.jpa.CampaignEntity;
import com.chutneytesting.campaign.infra.jpa.CampaignScenarioEntity;
import com.chutneytesting.execution.infra.storage.jpa.ScenarioExecutionEntity;
import com.chutneytesting.server.core.domain.execution.history.ExecutionHistory;
import com.chutneytesting.server.core.domain.execution.history.ImmutableExecutionHistory;
import com.chutneytesting.server.core.domain.execution.report.ServerReportStatus;
import com.chutneytesting.server.core.domain.scenario.campaign.CampaignExecution;
import com.chutneytesting.server.core.domain.scenario.campaign.ScenarioExecutionCampaign;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Version;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

@Entity(name="CAMPAIGN_EXECUTIONS")
public class CampaignExecutionEntity {
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="CAMPAIGN_ID")
    private Long campaignId;
    @OneToMany(mappedBy="campaignExecution")
    private List<ScenarioExecutionEntity> scenarioExecutions;
    @Column(name="PARTIAL")
    private Boolean partial;
    @Column(name="ENVIRONMENT")
    private String environment;
    @Column(name="USER_ID")
    private String userId;
    @Column(name="DATASET_ID")
    private String datasetId;
    @Column(name="DATASET_VERSION")
    private Integer datasetVersion;
    @Column(name="VERSION")
    @Version
    private Integer version;

    public CampaignExecutionEntity() {
    }

    public CampaignExecutionEntity(Long campaignId, String environment) {
        this(null, campaignId, null, null, environment, null, null, null, null);
    }

    public CampaignExecutionEntity(Long id, Long campaignId, List<ScenarioExecutionEntity> scenarioExecutions, Boolean partial, String environment, String userId, String datasetId, Integer datasetVersion, Integer version) {
        this.id = id;
        this.campaignId = campaignId;
        this.scenarioExecutions = scenarioExecutions;
        this.partial = Optional.ofNullable(partial).orElse(false);
        this.environment = environment;
        this.userId = userId;
        this.datasetId = datasetId;
        this.datasetVersion = datasetVersion;
        this.version = version;
    }

    public Long id() {
        return this.id;
    }

    public Long campaignId() {
        return this.campaignId;
    }

    public List<ScenarioExecutionEntity> scenarioExecutions() {
        return this.scenarioExecutions;
    }

    public void updateFromDomain(CampaignExecution report, Iterable<ScenarioExecutionEntity> scenarioExecutions) {
        this.partial = report.partialExecution;
        this.environment = report.executionEnvironment;
        this.userId = report.userId;
        this.datasetId = report.dataSetId.orElse(null);
        this.datasetVersion = report.dataSetVersion.orElse(null);
        this.scenarioExecutions.clear();
        scenarioExecutions.forEach(se -> {
            se.forCampaignExecution(this);
            this.scenarioExecutions.add((ScenarioExecutionEntity)se);
        });
    }

    public CampaignExecution toDomain(CampaignEntity campaign, boolean isRunning, Function<String, String> titleSupplier) {
        return this.toDomain(campaign, true, isRunning, titleSupplier);
    }

    public CampaignExecution toDomain(CampaignEntity campaign, boolean withScenariosExecutions, boolean isRunning, Function<String, String> scenarioTitleSupplier) {
        List scenarioExecutionCampaigns = Collections.emptyList();
        if (withScenariosExecutions) {
            scenarioExecutionCampaigns = isRunning ? (List)campaign.campaignScenarios().stream().map(cs -> this.scenarioExecutions.stream().filter(se -> se.scenarioId().equals(cs.scenarioId())).findFirst().map(se -> new ScenarioExecutionCampaign(se.scenarioId(), se.scenarioTitle(), se.toDomain())).orElseGet(() -> this.blankScenarioExecutionReport((CampaignScenarioEntity)cs, scenarioTitleSupplier))).collect(Collectors.toCollection(ArrayList::new)) : (List)this.scenarioExecutions.stream().map(se -> new ScenarioExecutionCampaign(se.scenarioId(), se.scenarioTitle(), se.toDomain())).collect(Collectors.toCollection(ArrayList::new));
        }
        return new CampaignExecution(this.id, this.campaignId, scenarioExecutionCampaigns, campaign.title(), Optional.ofNullable(this.partial).orElse(false).booleanValue(), this.environment, this.datasetId, this.datasetVersion, this.userId);
    }

    private ScenarioExecutionCampaign blankScenarioExecutionReport(CampaignScenarioEntity campaignScenarioEntity, Function<String, String> titleSupplier) {
        String scenarioTitle = titleSupplier.apply(campaignScenarioEntity.scenarioId());
        return new ScenarioExecutionCampaign(campaignScenarioEntity.scenarioId(), scenarioTitle, this.blankScenarioExecution(scenarioTitle, campaignScenarioEntity.scenarioId()));
    }

    private ExecutionHistory.ExecutionSummary blankScenarioExecution(String testCaseTitle, String scenarioId) {
        return ImmutableExecutionHistory.ExecutionSummary.builder().executionId(Long.valueOf(-1L)).testCaseTitle(testCaseTitle).time(LocalDateTime.now()).status(ServerReportStatus.NOT_EXECUTED).duration(0L).environment("").user("").scenarioId(scenarioId).build();
    }
}

