/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.campaign.infra;

import com.chutneytesting.campaign.infra.SchedulingCampaignDto;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

class SchedulingCampaignsDtoDeserializer
extends StdDeserializer<SchedulingCampaignDto> {
    protected SchedulingCampaignsDtoDeserializer() {
        super(SchedulingCampaignDto.class);
    }

    public SchedulingCampaignDto deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode node = (JsonNode)parser.readValueAsTree();
        String id = node.get("id").asText();
        LocalDateTime schedulingDate = this.getSchedulingDate(node);
        String frequency = this.getFrequency(node);
        List<Long> campaignsId = node.has("campaignId") ? List.of(Long.valueOf(node.get("campaignId").asLong())) : this.getCampaignsId(node.get("campaignsId"));
        List<String> campaignsTitle = node.has("campaignTitle") ? List.of(node.get("campaignTitle").asText()) : this.getCampaignsTitle(node.get("campaignsTitle"));
        return new SchedulingCampaignDto(id, campaignsId, campaignsTitle, schedulingDate, frequency);
    }

    private List<Long> getCampaignsId(JsonNode node) {
        ArrayList<Long> campaignsId = new ArrayList<Long>();
        for (JsonNode id : node) {
            campaignsId.add(id.asLong());
        }
        return campaignsId;
    }

    private List<String> getCampaignsTitle(JsonNode node) {
        ArrayList<String> campaignsTitle = new ArrayList<String>();
        for (JsonNode title : node) {
            campaignsTitle.add(title.asText());
        }
        return campaignsTitle;
    }

    private LocalDateTime getSchedulingDate(JsonNode node) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule());
        return (LocalDateTime)objectMapper.readValue(node.get("schedulingDate").toString(), LocalDateTime.class);
    }

    private String getFrequency(JsonNode node) throws JsonProcessingException {
        return node.has("frequency") ? node.get("frequency").asText() : null;
    }
}

