/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.admin.api;

import com.chutneytesting.admin.api.dto.BackupDto;
import com.chutneytesting.admin.api.dto.BackupMapper;
import com.chutneytesting.admin.domain.BackupRepository;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/backups"})
@CrossOrigin(origins={"*"})
public class BackupController {
    private final BackupRepository backupRepository;

    public BackupController(BackupRepository backupRepository) {
        this.backupRepository = backupRepository;
    }

    @PreAuthorize(value="hasAuthority('ADMIN_ACCESS')")
    @PostMapping(path={""}, consumes={"application/json"})
    public String backup(@RequestBody BackupDto backup) {
        return this.backupRepository.save(BackupMapper.fromDto(backup));
    }

    @PreAuthorize(value="hasAuthority('ADMIN_ACCESS')")
    @DeleteMapping(path={"/{backupId}"})
    public void delete(@PathVariable(value="backupId") String backupId) {
        this.backupRepository.delete(backupId);
    }

    @PreAuthorize(value="hasAuthority('ADMIN_ACCESS')")
    @GetMapping(path={"/{backupId}"}, produces={"application/json"})
    public BackupDto get(@PathVariable(value="backupId") String backupId) {
        return BackupMapper.toDto(this.backupRepository.read(backupId));
    }

    @PreAuthorize(value="hasAuthority('ADMIN_ACCESS')")
    @GetMapping(path={"/{backupId}/download"}, produces={"application/zip"})
    public void getBackupData(HttpServletResponse response, @PathVariable(value="backupId") String backupId) throws IOException {
        this.backupRepository.getBackupData(backupId, (OutputStream)response.getOutputStream());
    }

    @PreAuthorize(value="hasAuthority('ADMIN_ACCESS')")
    @GetMapping(path={""}, produces={"application/json"})
    public List<BackupDto> list() {
        return BackupMapper.toDtos(this.backupRepository.list());
    }

    @PreAuthorize(value="hasAuthority('ADMIN_ACCESS')")
    @GetMapping(path={"/backupables"}, produces={"application/json"})
    public List<String> getBackupables() {
        return this.backupRepository.getBackupables();
    }
}

