/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.domain.campaign;

import com.chutneytesting.campaign.domain.CampaignExecutionRepository;
import com.chutneytesting.campaign.domain.CampaignNotFoundException;
import com.chutneytesting.campaign.domain.CampaignRepository;
import com.chutneytesting.dataset.domain.DataSetRepository;
import com.chutneytesting.execution.domain.campaign.CampaignAlreadyRunningException;
import com.chutneytesting.execution.domain.campaign.CampaignExecutionNotFoundException;
import com.chutneytesting.execution.domain.campaign.JiraReportMapper;
import com.chutneytesting.jira.api.JiraXrayEmbeddedApi;
import com.chutneytesting.server.core.domain.dataset.DataSet;
import com.chutneytesting.server.core.domain.dataset.DataSetHistoryRepository;
import com.chutneytesting.server.core.domain.execution.ExecutionRequest;
import com.chutneytesting.server.core.domain.execution.FailedExecutionAttempt;
import com.chutneytesting.server.core.domain.execution.ScenarioExecutionEngine;
import com.chutneytesting.server.core.domain.execution.history.ExecutionHistory;
import com.chutneytesting.server.core.domain.execution.history.ExecutionHistoryRepository;
import com.chutneytesting.server.core.domain.execution.report.ScenarioExecutionReport;
import com.chutneytesting.server.core.domain.execution.report.ServerReportStatus;
import com.chutneytesting.server.core.domain.instrument.ChutneyMetrics;
import com.chutneytesting.server.core.domain.scenario.ScenarioNotFoundException;
import com.chutneytesting.server.core.domain.scenario.ScenarioNotParsableException;
import com.chutneytesting.server.core.domain.scenario.TestCase;
import com.chutneytesting.server.core.domain.scenario.TestCaseRepository;
import com.chutneytesting.server.core.domain.scenario.campaign.Campaign;
import com.chutneytesting.server.core.domain.scenario.campaign.CampaignExecution;
import com.chutneytesting.server.core.domain.scenario.campaign.ScenarioExecutionCampaign;
import com.chutneytesting.tools.Try;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CampaignExecutionEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(Campaign.class);
    private final ExecutorService executor;
    private final CampaignRepository campaignRepository;
    private final CampaignExecutionRepository campaignExecutionRepository;
    private final ScenarioExecutionEngine scenarioExecutionEngine;
    private final ExecutionHistoryRepository executionHistoryRepository;
    private final TestCaseRepository testCaseRepository;
    private final Optional<DataSetHistoryRepository> dataSetHistoryRepository;
    private final JiraXrayEmbeddedApi jiraXrayEmbeddedApi;
    private final ChutneyMetrics metrics;
    private final DataSetRepository datasetRepository;
    private final Map<Long, Boolean> currentCampaignExecutionsStopRequests = new ConcurrentHashMap<Long, Boolean>();
    private final ObjectMapper objectMapper;

    public CampaignExecutionEngine(CampaignRepository campaignRepository, CampaignExecutionRepository campaignExecutionRepository, ScenarioExecutionEngine scenarioExecutionEngine, ExecutionHistoryRepository executionHistoryRepository, TestCaseRepository testCaseRepository, Optional<DataSetHistoryRepository> dataSetHistoryRepository, JiraXrayEmbeddedApi jiraXrayEmbeddedApi, ChutneyMetrics metrics, ExecutorService executorService, DataSetRepository datasetRepository, ObjectMapper objectMapper) {
        this.campaignRepository = campaignRepository;
        this.campaignExecutionRepository = campaignExecutionRepository;
        this.scenarioExecutionEngine = scenarioExecutionEngine;
        this.executionHistoryRepository = executionHistoryRepository;
        this.testCaseRepository = testCaseRepository;
        this.dataSetHistoryRepository = dataSetHistoryRepository;
        this.jiraXrayEmbeddedApi = jiraXrayEmbeddedApi;
        this.metrics = metrics;
        this.executor = executorService;
        this.datasetRepository = datasetRepository;
        this.objectMapper = objectMapper;
    }

    public CampaignExecution getLastCampaignExecution(Long campaignId) {
        Campaign campaign = this.campaignRepository.findById(campaignId);
        return this.campaignExecutionRepository.getLastExecution(campaign.id);
    }

    public List<CampaignExecution> executeByName(String campaignName, String userId) {
        return this.executeByName(campaignName, null, userId);
    }

    public List<CampaignExecution> executeByName(String campaignName, String environment, String userId) {
        List<Campaign> campaigns = this.campaignRepository.findByName(campaignName);
        return campaigns.stream().map(campaign -> this.selectExecutionEnvironment((Campaign)campaign, environment)).map(campaign -> this.executeCampaign((Campaign)campaign, userId)).collect(Collectors.toList());
    }

    public CampaignExecution executeById(Long campaignId, String userId) {
        return this.executeById(campaignId, null, userId);
    }

    public CampaignExecution executeById(Long campaignId, String environment, String userId) {
        return Optional.ofNullable(this.campaignRepository.findById(campaignId)).map(campaign -> this.selectExecutionEnvironment((Campaign)campaign, environment)).map(campaign -> this.executeCampaign((Campaign)campaign, userId)).orElseThrow(() -> new CampaignNotFoundException(campaignId));
    }

    public Optional<CampaignExecution> currentExecution(Long campaignId) {
        return this.campaignExecutionRepository.currentExecution(campaignId);
    }

    public List<CampaignExecution> currentExecutions() {
        return this.campaignExecutionRepository.currentExecutions();
    }

    public void stopExecution(Long executionId) {
        LOGGER.trace("Stop requested for " + executionId);
        Optional.ofNullable(this.currentCampaignExecutionsStopRequests.computeIfPresent(executionId, (aLong, aBoolean) -> Boolean.TRUE)).orElseThrow(() -> new CampaignExecutionNotFoundException(executionId, null));
    }

    public CampaignExecution executeScenarioInCampaign(List<String> failedIds, Campaign campaign, String userId) {
        CampaignExecution campaignExecution;
        CampaignExecution campaignExecution2;
        Long executionId;
        block5: {
            this.verifyNotAlreadyRunning(campaign);
            executionId = this.campaignRepository.newCampaignExecution(campaign.id);
            campaignExecution2 = new CampaignExecution(executionId, campaign.title, !failedIds.isEmpty(), campaign.executionEnvironment(), StringUtils.isNotBlank((CharSequence)campaign.externalDatasetId) ? campaign.externalDatasetId : null, StringUtils.isNotBlank((CharSequence)campaign.externalDatasetId) && this.dataSetHistoryRepository.isPresent() ? this.dataSetHistoryRepository.get().lastVersion(campaign.externalDatasetId) : null, userId);
            this.campaignExecutionRepository.startExecution(campaign.id, campaignExecution2);
            this.currentCampaignExecutionsStopRequests.put(executionId, Boolean.FALSE);
            if (!failedIds.isEmpty()) break block5;
            CampaignExecution campaignExecution3 = this.execute(campaign, campaignExecution2, campaign.scenarioIds);
            campaignExecution2.endCampaignExecution();
            LOGGER.info("Save campaign {} execution {} with status {}", new Object[]{campaign.id, campaignExecution2.executionId, campaignExecution2.status()});
            this.currentCampaignExecutionsStopRequests.remove(executionId);
            this.campaignExecutionRepository.stopExecution(campaign.id);
            Try.exec(() -> {
                this.campaignRepository.saveExecution(campaign.id, campaignExecution2);
                return null;
            }).ifFailed(e -> LOGGER.error("Error saving report of campaign {} execution {}", (Object)campaign.id, (Object)campaignExecution.executionId));
            Try.exec(() -> {
                this.metrics.onCampaignExecutionEnded(campaign, campaignExecution2);
                return null;
            }).ifFailed(e -> LOGGER.error("Error saving metrics for campaign {} execution {}", (Object)campaign.id, (Object)campaignExecution.executionId));
            return campaignExecution3;
        }
        try {
            campaignExecution = this.execute(campaign, campaignExecution2, failedIds);
        }
        catch (Exception e2) {
            try {
                LOGGER.error("Not managed exception occurred", (Throwable)e2);
                throw new RuntimeException(e2);
            }
            catch (Throwable throwable) {
                campaignExecution2.endCampaignExecution();
                LOGGER.info("Save campaign {} execution {} with status {}", new Object[]{campaign.id, campaignExecution2.executionId, campaignExecution2.status()});
                this.currentCampaignExecutionsStopRequests.remove(executionId);
                this.campaignExecutionRepository.stopExecution(campaign.id);
                Try.exec(() -> {
                    this.campaignRepository.saveExecution(campaign.id, campaignExecution2);
                    return null;
                }).ifFailed(e -> LOGGER.error("Error saving report of campaign {} execution {}", (Object)campaign.id, (Object)campaignExecution.executionId));
                Try.exec(() -> {
                    this.metrics.onCampaignExecutionEnded(campaign, campaignExecution2);
                    return null;
                }).ifFailed(e -> LOGGER.error("Error saving metrics for campaign {} execution {}", (Object)campaign.id, (Object)campaignExecution.executionId));
                throw throwable;
            }
        }
        campaignExecution2.endCampaignExecution();
        LOGGER.info("Save campaign {} execution {} with status {}", new Object[]{campaign.id, campaignExecution2.executionId, campaignExecution2.status()});
        this.currentCampaignExecutionsStopRequests.remove(executionId);
        this.campaignExecutionRepository.stopExecution(campaign.id);
        Try.exec(() -> {
            this.campaignRepository.saveExecution(campaign.id, campaignExecution2);
            return null;
        }).ifFailed(e -> LOGGER.error("Error saving report of campaign {} execution {}", (Object)campaign.id, (Object)campaignExecution.executionId));
        Try.exec(() -> {
            this.metrics.onCampaignExecutionEnded(campaign, campaignExecution2);
            return null;
        }).ifFailed(e -> LOGGER.error("Error saving metrics for campaign {} execution {}", (Object)campaign.id, (Object)campaignExecution.executionId));
        return campaignExecution;
    }

    private CampaignExecution execute(Campaign campaign, CampaignExecution campaignExecution, List<String> scenariosToExecute) {
        LOGGER.trace("Execute campaign {} : {}", (Object)campaign.id, (Object)campaign.title);
        List testCases = scenariosToExecute.stream().map(arg_0 -> ((TestCaseRepository)this.testCaseRepository).findExecutableById(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        campaignExecution.initExecution(testCases, campaign.executionEnvironment(), campaignExecution.userId);
        try {
            if (campaign.parallelRun) {
                ArrayList toExecute = Lists.newArrayList();
                for (TestCase t : testCases) {
                    toExecute.add(Executors.callable(() -> this.executeScenarioInCampaign(campaign, campaignExecution).accept(t)));
                }
                this.executor.invokeAll(toExecute);
            } else {
                for (TestCase t : testCases) {
                    this.executor.invokeAll(Collections.singleton(Executors.callable(() -> this.executeScenarioInCampaign(campaign, campaignExecution).accept(t))));
                }
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Error ", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error ", (Throwable)e);
        }
        return campaignExecution;
    }

    private Consumer<TestCase> executeScenarioInCampaign(Campaign campaign, CampaignExecution campaignExecution) {
        return testCase -> {
            ScenarioExecutionCampaign scenarioExecution;
            if (!this.currentCampaignExecutionsStopRequests.get(campaignExecution.executionId).booleanValue()) {
                campaignExecution.startScenarioExecution(testCase, campaign.executionEnvironment(), campaignExecution.userId);
                scenarioExecution = this.executeScenario(campaign, (TestCase)testCase, campaignExecution);
                if (campaign.retryAuto && ServerReportStatus.FAILURE.equals((Object)scenarioExecution.status())) {
                    scenarioExecution = this.executeScenario(campaign, (TestCase)testCase, campaignExecution);
                }
            } else {
                scenarioExecution = this.generateNotExecutedScenarioExecutionAndReport(campaign, (TestCase)testCase, campaignExecution);
            }
            Optional.ofNullable(scenarioExecution).ifPresent(serc -> {
                campaignExecution.endScenarioExecution(serc);
                ExecutionHistory.Execution execution = this.executionHistoryRepository.getExecution(serc.scenarioId, serc.execution.executionId());
                this.jiraXrayEmbeddedApi.updateTestExecution(campaign.id, campaignExecution.executionId, serc.scenarioId, JiraReportMapper.from(execution.report(), this.objectMapper));
            });
        };
    }

    private ScenarioExecutionCampaign generateNotExecutedScenarioExecutionAndReport(Campaign campaign, TestCase testCase, CampaignExecution campaignExecution) {
        ExecutionRequest executionRequest = this.buildExecutionRequest(campaign, testCase, campaignExecution);
        ExecutionHistory.Execution execution = this.scenarioExecutionEngine.saveNotExecutedScenarioExecution(executionRequest);
        return new ScenarioExecutionCampaign(testCase.id(), testCase.metadata().title(), execution.summary());
    }

    private ScenarioExecutionCampaign executeScenario(Campaign campaign, TestCase testCase, CampaignExecution campaignExecution) {
        String scenarioName;
        Long executionId;
        try {
            LOGGER.trace("Execute scenario {} for campaign {}", (Object)testCase.id(), (Object)campaign.id);
            ExecutionRequest executionRequest = this.buildExecutionRequest(campaign, testCase, campaignExecution);
            ScenarioExecutionReport scenarioExecutionReport = this.scenarioExecutionEngine.execute(executionRequest);
            executionId = scenarioExecutionReport.executionId;
            scenarioName = scenarioExecutionReport.scenarioName;
        }
        catch (FailedExecutionAttempt e) {
            LOGGER.warn("Failed execution attempt for scenario {} for campaign {}", (Object)testCase.id(), (Object)campaign.id);
            executionId = e.executionId;
            scenarioName = e.title;
        }
        catch (ScenarioNotFoundException | ScenarioNotParsableException se) {
            LOGGER.error("Scenario error for scenario {} for campaign {}", new Object[]{testCase.id(), campaign.id, se});
            return null;
        }
        ExecutionHistory.Execution execution = this.executionHistoryRepository.getExecution(testCase.id(), executionId);
        return new ScenarioExecutionCampaign(testCase.id(), scenarioName, execution.summary());
    }

    private ExecutionRequest buildExecutionRequest(Campaign campaign, TestCase testCase, CampaignExecution campaignExecution) {
        return this.executionWithCombinedParametersFromCampaignAndTestCase(campaign, testCase, campaignExecution);
    }

    private ExecutionRequest executionWithCombinedParametersFromCampaignAndTestCase(Campaign campaign, TestCase testCase, CampaignExecution campaignExecution) {
        DataSet dataset = Optional.ofNullable(campaign.externalDatasetId).map(this.datasetRepository::findById).orElseGet(() -> this.datasetRepository.findById(testCase.metadata().defaultDataset()));
        return new ExecutionRequest(testCase, campaign.executionEnvironment(), campaignExecution.userId, dataset, campaignExecution);
    }

    private CampaignExecution executeCampaign(Campaign campaign, String userId) {
        return this.executeScenarioInCampaign(Collections.emptyList(), campaign, userId);
    }

    private void verifyNotAlreadyRunning(Campaign campaign) {
        Optional<CampaignExecution> currentReport = this.currentExecution(campaign.id);
        if (currentReport.isPresent() && !currentReport.get().status().isFinal()) {
            throw new CampaignAlreadyRunningException(currentReport.get());
        }
    }

    private Campaign selectExecutionEnvironment(Campaign campaign, String environment) {
        Optional.ofNullable(environment).ifPresent(arg_0 -> ((Campaign)campaign).executionEnvironment(arg_0));
        return campaign;
    }
}

