/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting;

import com.chutneytesting.campaign.domain.CampaignExecutionRepository;
import com.chutneytesting.campaign.domain.CampaignRepository;
import com.chutneytesting.execution.domain.PurgeServiceImpl;
import com.chutneytesting.server.core.domain.execution.history.ExecutionHistoryRepository;
import com.chutneytesting.server.core.domain.execution.history.PurgeService;
import com.chutneytesting.server.core.domain.scenario.TestCaseRepository;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.task.TaskExecutorBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.core.task.support.ExecutorServiceAdapter;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
@EnableScheduling
@EnableAsync
public class SchedulingConfiguration
implements AsyncConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulingConfiguration.class);

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return (ex, method, params) -> LOGGER.error("Uncaught exception in async execution", ex);
    }

    @Bean
    public TaskScheduler taskScheduler() {
        ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        threadPoolTaskScheduler.setPoolSize(2);
        threadPoolTaskScheduler.setThreadNamePrefix("task-exec");
        return threadPoolTaskScheduler;
    }

    @Bean
    public TaskExecutor applicationTaskExecutor(TaskExecutorBuilder builder) {
        return builder.threadNamePrefix("app-task-exec").build();
    }

    @Bean
    public TaskExecutor scheduleCampaignsExecutor() {
        return new SimpleAsyncTaskExecutor("schedule-campaigns-executor");
    }

    @Bean
    public ExecutorService scheduledCampaignsExecutor(@Value(value="${chutney.server.schedule-campaigns.executor.pool-size:20}") Integer threadForScheduledCampaigns) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(threadForScheduledCampaigns.intValue());
        executor.setMaxPoolSize(threadForScheduledCampaigns.intValue());
        executor.setThreadNamePrefix("scheduled-campaigns-executor");
        executor.initialize();
        LOGGER.debug("Pool for scheduled campaigns created with size {}", (Object)threadForScheduledCampaigns);
        return new ExecutorServiceAdapter((TaskExecutor)executor);
    }

    @Bean
    public PurgeService purgeService(TestCaseRepository testCaseRepository, ExecutionHistoryRepository executionRepository, CampaignRepository campaignRepository, CampaignExecutionRepository campaignExecutionRepository, @Value(value="${chutney.server.schedule-purge.max-scenario-executions:10}") Integer maxScenarioExecutionsConfig, @Value(value="${chutney.server.schedule-purge.max-campaign-executions:10}") Integer maxCampaignExecutionsConfig) {
        return new PurgeServiceImpl(testCaseRepository, executionRepository, campaignRepository, campaignExecutionRepository, maxScenarioExecutionsConfig, maxCampaignExecutionsConfig);
    }
}

