/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.scenario.api.raw.dto;

import com.chutneytesting.execution.api.ExecutionSummaryDto;
import com.chutneytesting.scenario.api.raw.dto.GwtScenarioDto;
import com.chutneytesting.scenario.api.raw.dto.GwtTestCaseDto;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GwtTestCaseDto", generator="Immutables")
@Immutable
public final class ImmutableGwtTestCaseDto
implements GwtTestCaseDto {
    @Nullable
    private final String id;
    private final String title;
    @Nullable
    private final String description;
    @Nullable
    private final String repositorySource;
    private final List<String> tags;
    private final List<ExecutionSummaryDto> executions;
    @Nullable
    private final Instant creationDate;
    private final GwtScenarioDto scenario;
    @Nullable
    private final String defaultDataset;
    private final Map<String, String> executionParameters;
    private final String author;
    private final Instant updateDate;
    private final Integer version;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGwtTestCaseDto(Builder builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.description = builder.description;
        this.repositorySource = builder.repositorySource;
        this.tags = ImmutableGwtTestCaseDto.createUnmodifiableList(true, builder.tags);
        this.executions = ImmutableGwtTestCaseDto.createUnmodifiableList(true, builder.executions);
        this.creationDate = builder.creationDate;
        this.scenario = builder.scenario;
        this.defaultDataset = builder.defaultDataset;
        this.executionParameters = ImmutableGwtTestCaseDto.createUnmodifiableMap(false, false, builder.executionParameters);
        if (builder.author != null) {
            this.initShim.author(builder.author);
        }
        if (builder.updateDate != null) {
            this.initShim.updateDate(builder.updateDate);
        }
        if (builder.version != null) {
            this.initShim.version(builder.version);
        }
        this.author = this.initShim.author();
        this.updateDate = this.initShim.updateDate();
        this.version = this.initShim.version();
        this.initShim = null;
    }

    private ImmutableGwtTestCaseDto(@Nullable String id, String title, @Nullable String description, @Nullable String repositorySource, List<String> tags, List<ExecutionSummaryDto> executions, @Nullable Instant creationDate, GwtScenarioDto scenario, @Nullable String defaultDataset, Map<String, String> executionParameters, String author, Instant updateDate, Integer version) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.repositorySource = repositorySource;
        this.tags = tags;
        this.executions = executions;
        this.creationDate = creationDate;
        this.scenario = scenario;
        this.defaultDataset = defaultDataset;
        this.executionParameters = executionParameters;
        this.author = author;
        this.updateDate = updateDate;
        this.version = version;
        this.initShim = null;
    }

    private String authorInitialize() {
        return GwtTestCaseDto.super.author();
    }

    private Instant updateDateInitialize() {
        return GwtTestCaseDto.super.updateDate();
    }

    private Integer versionInitialize() {
        return GwtTestCaseDto.super.version();
    }

    @Override
    @JsonProperty(value="id")
    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    @Override
    @JsonProperty(value="title")
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="repositorySource")
    public Optional<String> repositorySource() {
        return Optional.ofNullable(this.repositorySource);
    }

    @Override
    @JsonProperty(value="tags")
    public List<String> tags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="executions")
    public List<ExecutionSummaryDto> executions() {
        return this.executions;
    }

    @Override
    @JsonProperty(value="creationDate")
    public Optional<Instant> creationDate() {
        return Optional.ofNullable(this.creationDate);
    }

    @Override
    @JsonProperty(value="scenario")
    public GwtScenarioDto scenario() {
        return this.scenario;
    }

    @Override
    @JsonProperty(value="defaultDataset")
    public Optional<String> defaultDataset() {
        return Optional.ofNullable(this.defaultDataset);
    }

    @Override
    @JsonProperty(value="computedParameters")
    public Map<String, String> executionParameters() {
        return this.executionParameters;
    }

    @Override
    @JsonProperty(value="author")
    public String author() {
        InitShim shim = this.initShim;
        return shim != null ? shim.author() : this.author;
    }

    @Override
    @JsonProperty(value="updateDate")
    public Instant updateDate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.updateDate() : this.updateDate;
    }

    @Override
    @JsonProperty(value="version")
    public Integer version() {
        InitShim shim = this.initShim;
        return shim != null ? shim.version() : this.version;
    }

    public final ImmutableGwtTestCaseDto withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (Objects.equals(this.id, newValue)) {
            return this;
        }
        return new ImmutableGwtTestCaseDto(newValue, this.title, this.description, this.repositorySource, this.tags, this.executions, this.creationDate, this.scenario, this.defaultDataset, this.executionParameters, this.author, this.updateDate, this.version);
    }

    public final ImmutableGwtTestCaseDto withId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableGwtTestCaseDto(value, this.title, this.description, this.repositorySource, this.tags, this.executions, this.creationDate, this.scenario, this.defaultDataset, this.executionParameters, this.author, this.updateDate, this.version);
    }

    public final ImmutableGwtTestCaseDto withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableGwtTestCaseDto(this.id, newValue, this.description, this.repositorySource, this.tags, this.executions, this.creationDate, this.scenario, this.defaultDataset, this.executionParameters, this.author, this.updateDate, this.version);
    }

    public final ImmutableGwtTestCaseDto withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableGwtTestCaseDto(this.id, this.title, newValue, this.repositorySource, this.tags, this.executions, this.creationDate, this.scenario, this.defaultDataset, this.executionParameters, this.author, this.updateDate, this.version);
    }

    public final ImmutableGwtTestCaseDto withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableGwtTestCaseDto(this.id, this.title, value, this.repositorySource, this.tags, this.executions, this.creationDate, this.scenario, this.defaultDataset, this.executionParameters, this.author, this.updateDate, this.version);
    }

    public final ImmutableGwtTestCaseDto withRepositorySource(String value) {
        String newValue = Objects.requireNonNull(value, "repositorySource");
        if (Objects.equals(this.repositorySource, newValue)) {
            return this;
        }
        return new ImmutableGwtTestCaseDto(this.id, this.title, this.description, newValue, this.tags, this.executions, this.creationDate, this.scenario, this.defaultDataset, this.executionParameters, this.author, this.updateDate, this.version);
    }

    public final ImmutableGwtTestCaseDto withRepositorySource(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.repositorySource, value)) {
            return this;
        }
        return new ImmutableGwtTestCaseDto(this.id, this.title, this.description, value, this.tags, this.executions, this.creationDate, this.scenario, this.defaultDataset, this.executionParameters, this.author, this.updateDate, this.version);
    }

    public final ImmutableGwtTestCaseDto withTags(String ... elements) {
        List<String> newValue = ImmutableGwtTestCaseDto.createUnmodifiableList(false, ImmutableGwtTestCaseDto.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGwtTestCaseDto(this.id, this.title, this.description, this.repositorySource, newValue, this.executions, this.creationDate, this.scenario, this.defaultDataset, this.executionParameters, this.author, this.updateDate, this.version);
    }

    public final ImmutableGwtTestCaseDto withTags(Iterable<String> elements) {
        if (this.tags == elements) {
            return this;
        }
        List<String> newValue = ImmutableGwtTestCaseDto.createUnmodifiableList(false, ImmutableGwtTestCaseDto.createSafeList(elements, true, false));
        return new ImmutableGwtTestCaseDto(this.id, this.title, this.description, this.repositorySource, newValue, this.executions, this.creationDate, this.scenario, this.defaultDataset, this.executionParameters, this.author, this.updateDate, this.version);
    }

    public final ImmutableGwtTestCaseDto withExecutions(ExecutionSummaryDto ... elements) {
        List<ExecutionSummaryDto> newValue = ImmutableGwtTestCaseDto.createUnmodifiableList(false, ImmutableGwtTestCaseDto.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGwtTestCaseDto(this.id, this.title, this.description, this.repositorySource, this.tags, newValue, this.creationDate, this.scenario, this.defaultDataset, this.executionParameters, this.author, this.updateDate, this.version);
    }

    public final ImmutableGwtTestCaseDto withExecutions(Iterable<? extends ExecutionSummaryDto> elements) {
        if (this.executions == elements) {
            return this;
        }
        List<ExecutionSummaryDto> newValue = ImmutableGwtTestCaseDto.createUnmodifiableList(false, ImmutableGwtTestCaseDto.createSafeList(elements, true, false));
        return new ImmutableGwtTestCaseDto(this.id, this.title, this.description, this.repositorySource, this.tags, newValue, this.creationDate, this.scenario, this.defaultDataset, this.executionParameters, this.author, this.updateDate, this.version);
    }

    public final ImmutableGwtTestCaseDto withCreationDate(Instant value) {
        Instant newValue = Objects.requireNonNull(value, "creationDate");
        if (this.creationDate == newValue) {
            return this;
        }
        return new ImmutableGwtTestCaseDto(this.id, this.title, this.description, this.repositorySource, this.tags, this.executions, newValue, this.scenario, this.defaultDataset, this.executionParameters, this.author, this.updateDate, this.version);
    }

    public final ImmutableGwtTestCaseDto withCreationDate(Optional<? extends Instant> optional) {
        Instant value = optional.orElse(null);
        if (this.creationDate == value) {
            return this;
        }
        return new ImmutableGwtTestCaseDto(this.id, this.title, this.description, this.repositorySource, this.tags, this.executions, value, this.scenario, this.defaultDataset, this.executionParameters, this.author, this.updateDate, this.version);
    }

    public final ImmutableGwtTestCaseDto withScenario(GwtScenarioDto value) {
        if (this.scenario == value) {
            return this;
        }
        GwtScenarioDto newValue = Objects.requireNonNull(value, "scenario");
        return new ImmutableGwtTestCaseDto(this.id, this.title, this.description, this.repositorySource, this.tags, this.executions, this.creationDate, newValue, this.defaultDataset, this.executionParameters, this.author, this.updateDate, this.version);
    }

    public final ImmutableGwtTestCaseDto withDefaultDataset(String value) {
        String newValue = Objects.requireNonNull(value, "defaultDataset");
        if (Objects.equals(this.defaultDataset, newValue)) {
            return this;
        }
        return new ImmutableGwtTestCaseDto(this.id, this.title, this.description, this.repositorySource, this.tags, this.executions, this.creationDate, this.scenario, newValue, this.executionParameters, this.author, this.updateDate, this.version);
    }

    public final ImmutableGwtTestCaseDto withDefaultDataset(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.defaultDataset, value)) {
            return this;
        }
        return new ImmutableGwtTestCaseDto(this.id, this.title, this.description, this.repositorySource, this.tags, this.executions, this.creationDate, this.scenario, value, this.executionParameters, this.author, this.updateDate, this.version);
    }

    public final ImmutableGwtTestCaseDto withExecutionParameters(Map<String, ? extends String> entries) {
        if (this.executionParameters == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableGwtTestCaseDto.createUnmodifiableMap(true, false, entries);
        return new ImmutableGwtTestCaseDto(this.id, this.title, this.description, this.repositorySource, this.tags, this.executions, this.creationDate, this.scenario, this.defaultDataset, newValue, this.author, this.updateDate, this.version);
    }

    public final ImmutableGwtTestCaseDto withAuthor(String value) {
        String newValue = Objects.requireNonNull(value, "author");
        if (this.author.equals(newValue)) {
            return this;
        }
        return new ImmutableGwtTestCaseDto(this.id, this.title, this.description, this.repositorySource, this.tags, this.executions, this.creationDate, this.scenario, this.defaultDataset, this.executionParameters, newValue, this.updateDate, this.version);
    }

    public final ImmutableGwtTestCaseDto withUpdateDate(Instant value) {
        if (this.updateDate == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "updateDate");
        return new ImmutableGwtTestCaseDto(this.id, this.title, this.description, this.repositorySource, this.tags, this.executions, this.creationDate, this.scenario, this.defaultDataset, this.executionParameters, this.author, newValue, this.version);
    }

    public final ImmutableGwtTestCaseDto withVersion(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutableGwtTestCaseDto(this.id, this.title, this.description, this.repositorySource, this.tags, this.executions, this.creationDate, this.scenario, this.defaultDataset, this.executionParameters, this.author, this.updateDate, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGwtTestCaseDto && this.equalTo(0, (ImmutableGwtTestCaseDto)another);
    }

    private boolean equalTo(int synthetic, ImmutableGwtTestCaseDto another) {
        return Objects.equals(this.id, another.id) && this.title.equals(another.title) && Objects.equals(this.description, another.description) && Objects.equals(this.repositorySource, another.repositorySource) && this.tags.equals(another.tags) && this.executions.equals(another.executions) && Objects.equals(this.creationDate, another.creationDate) && this.scenario.equals(another.scenario) && Objects.equals(this.defaultDataset, another.defaultDataset) && this.executionParameters.equals(another.executionParameters) && this.author.equals(another.author) && this.updateDate.equals(another.updateDate) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.repositorySource);
        h += (h << 5) + this.tags.hashCode();
        h += (h << 5) + this.executions.hashCode();
        h += (h << 5) + Objects.hashCode(this.creationDate);
        h += (h << 5) + this.scenario.hashCode();
        h += (h << 5) + Objects.hashCode(this.defaultDataset);
        h += (h << 5) + this.executionParameters.hashCode();
        h += (h << 5) + this.author.hashCode();
        h += (h << 5) + this.updateDate.hashCode();
        h += (h << 5) + this.version.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("GwtTestCaseDto{");
        if (this.id != null) {
            builder.append("id=").append(this.id);
        }
        if (builder.length() > 15) {
            builder.append(", ");
        }
        builder.append("title=").append(this.title);
        if (this.description != null) {
            builder.append(", ");
            builder.append("description=").append(this.description);
        }
        if (this.repositorySource != null) {
            builder.append(", ");
            builder.append("repositorySource=").append(this.repositorySource);
        }
        builder.append(", ");
        builder.append("tags=").append(this.tags);
        builder.append(", ");
        builder.append("executions=").append(this.executions);
        if (this.creationDate != null) {
            builder.append(", ");
            builder.append("creationDate=").append(this.creationDate);
        }
        builder.append(", ");
        builder.append("scenario=").append(this.scenario);
        if (this.defaultDataset != null) {
            builder.append(", ");
            builder.append("defaultDataset=").append(this.defaultDataset);
        }
        builder.append(", ");
        builder.append("executionParameters=").append(this.executionParameters);
        builder.append(", ");
        builder.append("author=").append(this.author);
        builder.append(", ");
        builder.append("updateDate=").append(this.updateDate);
        builder.append(", ");
        builder.append("version=").append(this.version);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGwtTestCaseDto fromJson(Json json) {
        Builder builder = ImmutableGwtTestCaseDto.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.repositorySource != null) {
            builder.repositorySource(json.repositorySource);
        }
        if (json.tags != null) {
            builder.addAllTags(json.tags);
        }
        if (json.executions != null) {
            builder.addAllExecutions(json.executions);
        }
        if (json.creationDate != null) {
            builder.creationDate(json.creationDate);
        }
        if (json.scenario != null) {
            builder.scenario(json.scenario);
        }
        if (json.defaultDataset != null) {
            builder.defaultDataset(json.defaultDataset);
        }
        if (json.executionParameters != null) {
            builder.putAllExecutionParameters(json.executionParameters);
        }
        if (json.author != null) {
            builder.author(json.author);
        }
        if (json.updateDate != null) {
            builder.updateDate(json.updateDate);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        return builder.build();
    }

    public static ImmutableGwtTestCaseDto copyOf(GwtTestCaseDto instance) {
        if (instance instanceof ImmutableGwtTestCaseDto) {
            return (ImmutableGwtTestCaseDto)instance;
        }
        return ImmutableGwtTestCaseDto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="GwtTestCaseDto", generator="Immutables")
    private final class InitShim {
        private byte authorBuildStage = 0;
        private String author;
        private byte updateDateBuildStage = 0;
        private Instant updateDate;
        private byte versionBuildStage = 0;
        private Integer version;

        private InitShim() {
        }

        String author() {
            if (this.authorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.authorBuildStage == 0) {
                this.authorBuildStage = (byte)-1;
                this.author = Objects.requireNonNull(ImmutableGwtTestCaseDto.this.authorInitialize(), "author");
                this.authorBuildStage = 1;
            }
            return this.author;
        }

        void author(String author) {
            this.author = author;
            this.authorBuildStage = 1;
        }

        Instant updateDate() {
            if (this.updateDateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.updateDateBuildStage == 0) {
                this.updateDateBuildStage = (byte)-1;
                this.updateDate = Objects.requireNonNull(ImmutableGwtTestCaseDto.this.updateDateInitialize(), "updateDate");
                this.updateDateBuildStage = 1;
            }
            return this.updateDate;
        }

        void updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            this.updateDateBuildStage = 1;
        }

        Integer version() {
            if (this.versionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.versionBuildStage == 0) {
                this.versionBuildStage = (byte)-1;
                this.version = Objects.requireNonNull(ImmutableGwtTestCaseDto.this.versionInitialize(), "version");
                this.versionBuildStage = 1;
            }
            return this.version;
        }

        void version(Integer version) {
            this.version = version;
            this.versionBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.authorBuildStage == -1) {
                attributes.add("author");
            }
            if (this.updateDateBuildStage == -1) {
                attributes.add("updateDate");
            }
            if (this.versionBuildStage == -1) {
                attributes.add("version");
            }
            return "Cannot build GwtTestCaseDto, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="GwtTestCaseDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private static final long INIT_BIT_SCENARIO = 2L;
        private long initBits = 3L;
        @Nullable
        private String id;
        @Nullable
        private String title;
        @Nullable
        private String description;
        @Nullable
        private String repositorySource;
        private List<String> tags = new ArrayList<String>();
        private List<ExecutionSummaryDto> executions = new ArrayList<ExecutionSummaryDto>();
        @Nullable
        private Instant creationDate;
        @Nullable
        private GwtScenarioDto scenario;
        @Nullable
        private String defaultDataset;
        private Map<String, String> executionParameters = new LinkedHashMap<String, String>();
        @Nullable
        private String author;
        @Nullable
        private Instant updateDate;
        @Nullable
        private Integer version;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GwtTestCaseDto instance) {
            Optional<String> repositorySourceOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> idOptional = instance.id();
            if (idOptional.isPresent()) {
                this.id(idOptional);
            }
            this.title(instance.title());
            Optional<String> descriptionOptional = instance.description();
            if (descriptionOptional.isPresent()) {
                this.description(descriptionOptional);
            }
            if ((repositorySourceOptional = instance.repositorySource()).isPresent()) {
                this.repositorySource(repositorySourceOptional);
            }
            this.addAllTags(instance.tags());
            this.addAllExecutions(instance.executions());
            Optional<Instant> creationDateOptional = instance.creationDate();
            if (creationDateOptional.isPresent()) {
                this.creationDate(creationDateOptional);
            }
            this.scenario(instance.scenario());
            Optional<String> defaultDatasetOptional = instance.defaultDataset();
            if (defaultDatasetOptional.isPresent()) {
                this.defaultDataset(defaultDatasetOptional);
            }
            this.putAllExecutionParameters(instance.executionParameters());
            this.author(instance.author());
            this.updateDate(instance.updateDate());
            this.version(instance.version());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(Optional<String> id) {
            this.id = id.orElse(null);
            return this;
        }

        @JsonProperty(value="title")
        @CanIgnoreReturnValue
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repositorySource(String repositorySource) {
            this.repositorySource = Objects.requireNonNull(repositorySource, "repositorySource");
            return this;
        }

        @JsonProperty(value="repositorySource")
        @CanIgnoreReturnValue
        public final Builder repositorySource(Optional<String> repositorySource) {
            this.repositorySource = repositorySource.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String element) {
            this.tags.add(Objects.requireNonNull(element, "tags element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(String ... elements) {
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        @JsonProperty(value="tags")
        @CanIgnoreReturnValue
        public final Builder tags(Iterable<String> elements) {
            this.tags.clear();
            return this.addAllTags(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTags(Iterable<String> elements) {
            for (String element : elements) {
                this.tags.add(Objects.requireNonNull(element, "tags element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExecutions(ExecutionSummaryDto element) {
            this.executions.add(Objects.requireNonNull(element, "executions element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExecutions(ExecutionSummaryDto ... elements) {
            for (ExecutionSummaryDto element : elements) {
                this.executions.add(Objects.requireNonNull(element, "executions element"));
            }
            return this;
        }

        @JsonProperty(value="executions")
        @CanIgnoreReturnValue
        public final Builder executions(Iterable<? extends ExecutionSummaryDto> elements) {
            this.executions.clear();
            return this.addAllExecutions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExecutions(Iterable<? extends ExecutionSummaryDto> elements) {
            for (ExecutionSummaryDto executionSummaryDto : elements) {
                this.executions.add(Objects.requireNonNull(executionSummaryDto, "executions element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = Objects.requireNonNull(creationDate, "creationDate");
            return this;
        }

        @JsonProperty(value="creationDate")
        @CanIgnoreReturnValue
        public final Builder creationDate(Optional<? extends Instant> creationDate) {
            this.creationDate = creationDate.orElse(null);
            return this;
        }

        @JsonProperty(value="scenario")
        @CanIgnoreReturnValue
        public final Builder scenario(GwtScenarioDto scenario) {
            this.scenario = Objects.requireNonNull(scenario, "scenario");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultDataset(String defaultDataset) {
            this.defaultDataset = Objects.requireNonNull(defaultDataset, "defaultDataset");
            return this;
        }

        @JsonProperty(value="defaultDataset")
        @CanIgnoreReturnValue
        public final Builder defaultDataset(Optional<String> defaultDataset) {
            this.defaultDataset = defaultDataset.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putExecutionParameters(String key, String value) {
            this.executionParameters.put(Objects.requireNonNull(key, "executionParameters key"), Objects.requireNonNull(value, "executionParameters value"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putExecutionParameters(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.executionParameters.put(Objects.requireNonNull(k, "executionParameters key"), Objects.requireNonNull(v, "executionParameters value"));
            return this;
        }

        @JsonProperty(value="computedParameters")
        @CanIgnoreReturnValue
        public final Builder executionParameters(Map<String, ? extends String> entries) {
            this.executionParameters.clear();
            return this.putAllExecutionParameters(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllExecutionParameters(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.executionParameters.put(Objects.requireNonNull(k, "executionParameters key"), Objects.requireNonNull(v, "executionParameters value"));
            }
            return this;
        }

        @JsonProperty(value="author")
        @CanIgnoreReturnValue
        public final Builder author(String author) {
            this.author = Objects.requireNonNull(author, "author");
            return this;
        }

        @JsonProperty(value="updateDate")
        @CanIgnoreReturnValue
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = Objects.requireNonNull(updateDate, "updateDate");
            return this;
        }

        @JsonProperty(value="version")
        @CanIgnoreReturnValue
        public final Builder version(Integer version) {
            this.version = Objects.requireNonNull(version, "version");
            return this;
        }

        public ImmutableGwtTestCaseDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGwtTestCaseDto(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("scenario");
            }
            return "Cannot build GwtTestCaseDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GwtTestCaseDto", generator="Immutables")
    static final class Json
    implements GwtTestCaseDto {
        @Nullable
        Optional<String> id = Optional.empty();
        @Nullable
        String title;
        @Nullable
        Optional<String> description = Optional.empty();
        @Nullable
        Optional<String> repositorySource = Optional.empty();
        @Nullable
        List<String> tags = Collections.emptyList();
        @Nullable
        List<ExecutionSummaryDto> executions = Collections.emptyList();
        @Nullable
        Optional<Instant> creationDate = Optional.empty();
        @Nullable
        GwtScenarioDto scenario;
        @Nullable
        Optional<String> defaultDataset = Optional.empty();
        @Nullable
        Map<String, String> executionParameters = Collections.emptyMap();
        @Nullable
        String author;
        @Nullable
        Instant updateDate;
        @Nullable
        Integer version;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Optional<String> id) {
            this.id = id;
        }

        @JsonProperty(value="title")
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty(value="description")
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty(value="repositorySource")
        public void setRepositorySource(Optional<String> repositorySource) {
            this.repositorySource = repositorySource;
        }

        @JsonProperty(value="tags")
        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="executions")
        public void setExecutions(List<ExecutionSummaryDto> executions) {
            this.executions = executions;
        }

        @JsonProperty(value="creationDate")
        public void setCreationDate(Optional<Instant> creationDate) {
            this.creationDate = creationDate;
        }

        @JsonProperty(value="scenario")
        public void setScenario(GwtScenarioDto scenario) {
            this.scenario = scenario;
        }

        @JsonProperty(value="defaultDataset")
        public void setDefaultDataset(Optional<String> defaultDataset) {
            this.defaultDataset = defaultDataset;
        }

        @JsonProperty(value="computedParameters")
        public void setExecutionParameters(Map<String, String> executionParameters) {
            this.executionParameters = executionParameters;
        }

        @JsonProperty(value="author")
        public void setAuthor(String author) {
            this.author = author;
        }

        @JsonProperty(value="updateDate")
        public void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        @JsonProperty(value="version")
        public void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public Optional<String> id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String title() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> repositorySource() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> tags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ExecutionSummaryDto> executions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Instant> creationDate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GwtScenarioDto scenario() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> defaultDataset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> executionParameters() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String author() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant updateDate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer version() {
            throw new UnsupportedOperationException();
        }
    }
}

