/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.infra.storage;

import com.chutneytesting.server.core.domain.execution.history.ExecutionHistory;
import com.chutneytesting.server.core.domain.execution.history.ImmutableExecutionHistory;
import com.chutneytesting.server.core.domain.execution.report.ServerReportStatus;
import com.chutneytesting.server.core.domain.scenario.campaign.CampaignExecution;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.jdbc.core.RowMapper;

class ExecutionSummaryRowMapper
implements RowMapper<ExecutionHistory.ExecutionSummary> {
    ExecutionSummaryRowMapper() {
    }

    public ExecutionHistory.ExecutionSummary mapRow(ResultSet rs, int rowNum) throws SQLException {
        ImmutableExecutionHistory.ExecutionSummary.Builder builder = ImmutableExecutionHistory.ExecutionSummary.builder().executionId(Long.valueOf(rs.getLong("ID"))).time(Instant.ofEpochMilli(rs.getLong("EXECUTION_TIME")).atZone(ZoneId.systemDefault()).toLocalDateTime()).duration(rs.getLong("DURATION")).status(ServerReportStatus.valueOf((String)rs.getString("STATUS"))).info(Optional.ofNullable(rs.getString("INFORMATION"))).error(Optional.ofNullable(rs.getString("ERROR"))).testCaseTitle(rs.getString("TEST_CASE_TITLE")).environment(rs.getString("ENVIRONMENT")).datasetId(Optional.ofNullable(rs.getString("DATASET_ID"))).datasetVersion(Optional.ofNullable(rs.getString("DATASET_VERSION")).map(Integer::valueOf)).user(rs.getString("USER_ID"));
        this.addCampaignReportIfExist(rs, builder);
        return builder.build();
    }

    private void addCampaignReportIfExist(ResultSet rs, ImmutableExecutionHistory.ExecutionSummary.Builder builder) {
        try {
            if (rs.getLong("CAMPAIGN_EXECUTION_ID") > 0L) {
                builder.campaignReport(this.mapCampaignExecutionReport(rs));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private Optional<CampaignExecution> mapCampaignExecutionReport(ResultSet rs) throws SQLException {
        CampaignExecution report = new CampaignExecution(Long.valueOf(rs.getLong("CAMPAIGN_EXECUTION_ID")), Long.valueOf(rs.getLong("CAMPAIGN_ID")), new ArrayList(), rs.getString("CAMPAIGN_TITLE"), false, null, null, null, null);
        return Optional.of(report);
    }
}

