/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.campaign.infra.jpa;

import com.chutneytesting.campaign.infra.jpa.CampaignEntity;
import com.chutneytesting.server.core.domain.scenario.campaign.Campaign;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.util.Set;
import java.util.stream.Collectors;

@Entity(name="CAMPAIGN_PARAMETERS")
public class CampaignParameterEntity {
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CAMPAIGN_ID")
    private CampaignEntity campaign;
    @Column(name="PARAMETER")
    private String parameter;
    @Column(name="PARAMETER_VALUE")
    private String value;

    CampaignParameterEntity() {
    }

    public CampaignParameterEntity(String parameter, String value) {
        this(null, parameter, value);
    }

    public CampaignParameterEntity(CampaignEntity campaign, String parameter, String value) {
        this.campaign = campaign;
        this.parameter = parameter;
        this.value = value;
    }

    public String parameter() {
        return this.parameter;
    }

    public String value() {
        return this.value;
    }

    public void forCampaign(CampaignEntity campaign) {
        this.campaign = campaign;
    }

    public static Set<CampaignParameterEntity> fromDomain(Campaign campaign) {
        return campaign.executionParameters.entrySet().stream().map(e -> new CampaignParameterEntity((String)e.getKey(), (String)e.getValue())).collect(Collectors.toSet());
    }
}

