/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.campaign.api.dto;

import com.chutneytesting.campaign.api.dto.CampaignDto;
import com.chutneytesting.campaign.api.dto.CampaignExecutionReportDto;
import com.chutneytesting.campaign.api.dto.CampaignExecutionReportMapper;
import com.chutneytesting.server.core.domain.scenario.campaign.Campaign;
import com.chutneytesting.server.core.domain.scenario.campaign.CampaignExecution;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class CampaignMapper {
    public static CampaignDto toDtoWithoutReport(Campaign campaign) {
        return new CampaignDto(campaign.id, campaign.title, campaign.description, campaign.scenarioIds, campaign.executionParameters, Collections.emptyList(), campaign.executionEnvironment(), campaign.parallelRun, campaign.retryAuto, campaign.externalDatasetId, campaign.tags);
    }

    public static CampaignDto toDto(Campaign campaign, List<CampaignExecution> campaignExecutions) {
        return new CampaignDto(campaign.id, campaign.title, campaign.description, campaign.scenarioIds, campaign.executionParameters, CampaignMapper.reportToDto(campaignExecutions), campaign.executionEnvironment(), campaign.parallelRun, campaign.retryAuto, campaign.externalDatasetId, campaign.tags);
    }

    public static Campaign fromDto(CampaignDto dto) {
        return new Campaign(dto.getId(), dto.getTitle(), dto.getDescription(), dto.getScenarioIds(), dto.getExecutionParameters(), dto.getEnvironment(), dto.isParallelRun(), dto.isRetryAuto(), dto.getDatasetId(), dto.getTags().stream().map(String::trim).map(String::toUpperCase).collect(Collectors.toList()));
    }

    private static List<CampaignExecutionReportDto> reportToDto(List<CampaignExecution> campaignExecutions) {
        return campaignExecutions != null ? campaignExecutions.stream().map(CampaignExecutionReportMapper::toDto).collect(Collectors.toList()) : Collections.emptyList();
    }
}

