package com.chutneytesting.execution.api;

import com.chutneytesting.server.core.domain.execution.report.ScenarioExecutionReport;
import com.chutneytesting.server.core.domain.execution.report.ServerReportStatus;
import com.chutneytesting.server.core.domain.execution.report.StepExecutionReportCore;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2023-10-24T15:19:14+0000",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 17.0.9 (Eclipse Adoptium)"
)
@Component
public class ScenarioExecutionReportCoreMapperImpl implements ScenarioExecutionReportCoreMapper {

    @Override
    public ScenarioExecutionReportDto toDto(ScenarioExecutionReport source) {
        if ( source == null ) {
            return null;
        }

        long executionId = 0L;
        String scenarioName = null;
        String environment = null;
        String user = null;
        Map<String, Object> contextVariables = null;
        StepExecutionReportCoreDto report = null;

        executionId = source.executionId;
        scenarioName = source.scenarioName;
        environment = source.environment;
        user = source.user;
        Map<String, Object> map = source.contextVariables;
        if ( map != null ) {
            contextVariables = new LinkedHashMap<String, Object>( map );
        }
        report = stepExecutionReportCoreToStepExecutionReportCoreDto( source.report );

        ScenarioExecutionReportDto scenarioExecutionReportDto = new ScenarioExecutionReportDto( executionId, scenarioName, environment, user, contextVariables, report );

        return scenarioExecutionReportDto;
    }

    @Override
    public ScenarioExecutionReport toDomain(ScenarioExecutionReportDto destination) {
        if ( destination == null ) {
            return null;
        }

        long executionId = 0L;
        String scenarioName = null;
        String environment = null;
        String user = null;
        StepExecutionReportCore report = null;

        executionId = destination.executionId();
        scenarioName = destination.scenarioName();
        environment = destination.environment();
        user = destination.user();
        report = stepExecutionReportCoreDtoToStepExecutionReportCore( destination.report() );

        ScenarioExecutionReport scenarioExecutionReport = new ScenarioExecutionReport( executionId, scenarioName, environment, user, report );

        return scenarioExecutionReport;
    }

    protected List<StepExecutionReportCoreDto> stepExecutionReportCoreListToStepExecutionReportCoreDtoList(List<StepExecutionReportCore> list) {
        if ( list == null ) {
            return null;
        }

        List<StepExecutionReportCoreDto> list1 = new ArrayList<StepExecutionReportCoreDto>( list.size() );
        for ( StepExecutionReportCore stepExecutionReportCore : list ) {
            list1.add( stepExecutionReportCoreToStepExecutionReportCoreDto( stepExecutionReportCore ) );
        }

        return list1;
    }

    protected StepExecutionReportCoreDto stepExecutionReportCoreToStepExecutionReportCoreDto(StepExecutionReportCore stepExecutionReportCore) {
        if ( stepExecutionReportCore == null ) {
            return null;
        }

        String name = null;
        Long duration = null;
        Instant startDate = null;
        ServerReportStatus status = null;
        List<String> information = null;
        List<String> errors = null;
        List<StepExecutionReportCoreDto> steps = null;
        String type = null;
        String targetName = null;
        String targetUrl = null;
        String strategy = null;
        Map<String, Object> evaluatedInputs = null;
        Map<String, Object> stepOutputs = null;

        name = stepExecutionReportCore.name;
        duration = stepExecutionReportCore.duration;
        startDate = stepExecutionReportCore.startDate;
        status = stepExecutionReportCore.getStatus();
        List<String> list = stepExecutionReportCore.information;
        if ( list != null ) {
            information = new ArrayList<String>( list );
        }
        List<String> list1 = stepExecutionReportCore.errors;
        if ( list1 != null ) {
            errors = new ArrayList<String>( list1 );
        }
        steps = stepExecutionReportCoreListToStepExecutionReportCoreDtoList( stepExecutionReportCore.steps );
        type = stepExecutionReportCore.type;
        targetName = stepExecutionReportCore.targetName;
        targetUrl = stepExecutionReportCore.targetUrl;
        strategy = stepExecutionReportCore.strategy;
        Map<String, Object> map = stepExecutionReportCore.evaluatedInputs;
        if ( map != null ) {
            evaluatedInputs = new LinkedHashMap<String, Object>( map );
        }
        Map<String, Object> map1 = stepExecutionReportCore.stepOutputs;
        if ( map1 != null ) {
            stepOutputs = new LinkedHashMap<String, Object>( map1 );
        }

        StepExecutionReportCoreDto stepExecutionReportCoreDto = new StepExecutionReportCoreDto( name, duration, startDate, status, information, errors, steps, type, targetName, targetUrl, strategy, evaluatedInputs, stepOutputs );

        return stepExecutionReportCoreDto;
    }

    protected List<StepExecutionReportCore> stepExecutionReportCoreDtoListToStepExecutionReportCoreList(List<StepExecutionReportCoreDto> list) {
        if ( list == null ) {
            return null;
        }

        List<StepExecutionReportCore> list1 = new ArrayList<StepExecutionReportCore>( list.size() );
        for ( StepExecutionReportCoreDto stepExecutionReportCoreDto : list ) {
            list1.add( stepExecutionReportCoreDtoToStepExecutionReportCore( stepExecutionReportCoreDto ) );
        }

        return list1;
    }

    protected StepExecutionReportCore stepExecutionReportCoreDtoToStepExecutionReportCore(StepExecutionReportCoreDto stepExecutionReportCoreDto) {
        if ( stepExecutionReportCoreDto == null ) {
            return null;
        }

        String name = null;
        Long duration = null;
        Instant startDate = null;
        ServerReportStatus status = null;
        List<String> information = null;
        List<String> errors = null;
        List<StepExecutionReportCore> steps = null;
        String type = null;
        String targetName = null;
        String targetUrl = null;
        String strategy = null;
        Map<String, Object> evaluatedInputs = null;
        Map<String, Object> stepOutputs = null;

        name = stepExecutionReportCoreDto.name();
        duration = stepExecutionReportCoreDto.duration();
        startDate = stepExecutionReportCoreDto.startDate();
        status = stepExecutionReportCoreDto.status();
        List<String> list = stepExecutionReportCoreDto.information();
        if ( list != null ) {
            information = new ArrayList<String>( list );
        }
        List<String> list1 = stepExecutionReportCoreDto.errors();
        if ( list1 != null ) {
            errors = new ArrayList<String>( list1 );
        }
        steps = stepExecutionReportCoreDtoListToStepExecutionReportCoreList( stepExecutionReportCoreDto.steps() );
        type = stepExecutionReportCoreDto.type();
        targetName = stepExecutionReportCoreDto.targetName();
        targetUrl = stepExecutionReportCoreDto.targetUrl();
        strategy = stepExecutionReportCoreDto.strategy();
        Map<String, Object> map = stepExecutionReportCoreDto.evaluatedInputs();
        if ( map != null ) {
            evaluatedInputs = new LinkedHashMap<String, Object>( map );
        }
        Map<String, Object> map1 = stepExecutionReportCoreDto.stepOutputs();
        if ( map1 != null ) {
            stepOutputs = new LinkedHashMap<String, Object>( map1 );
        }

        StepExecutionReportCore stepExecutionReportCore = new StepExecutionReportCore( name, duration, startDate, status, information, errors, steps, type, targetName, targetUrl, strategy, evaluatedInputs, stepOutputs );

        return stepExecutionReportCore;
    }
}
