/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.scenario.infra.raw;

import com.chutneytesting.campaign.infra.CampaignScenarioJpaRepository;
import com.chutneytesting.campaign.infra.jpa.CampaignScenario;
import com.chutneytesting.execution.infra.storage.DatabaseExecutionJpaRepository;
import com.chutneytesting.execution.infra.storage.jpa.ScenarioExecution;
import com.chutneytesting.scenario.domain.gwt.GwtTestCase;
import com.chutneytesting.scenario.infra.jpa.Scenario;
import com.chutneytesting.scenario.infra.raw.ScenarioJpaRepository;
import com.chutneytesting.server.core.domain.scenario.AggregatedRepository;
import com.chutneytesting.server.core.domain.scenario.ScenarioNotFoundException;
import com.chutneytesting.server.core.domain.scenario.ScenarioNotParsableException;
import com.chutneytesting.server.core.domain.scenario.TestCase;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadata;
import com.google.common.base.Strings;
import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.orm.ObjectOptimisticLockingFailureException;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class DatabaseTestCaseRepository
implements AggregatedRepository<GwtTestCase> {
    private final ScenarioJpaRepository scenarioJpaRepository;
    private final DatabaseExecutionJpaRepository scenarioExecutionsJpaRepository;
    private final CampaignScenarioJpaRepository campaignScenarioJpaRepository;
    private final EntityManager entityManager;
    private final Pattern pattern = Pattern.compile("\"([^\"]*)\"");

    public DatabaseTestCaseRepository(ScenarioJpaRepository jpa, DatabaseExecutionJpaRepository scenarioExecutionsJpaRepository, CampaignScenarioJpaRepository campaignScenarioJpaRepository, EntityManager entityManager) {
        this.scenarioJpaRepository = jpa;
        this.scenarioExecutionsJpaRepository = scenarioExecutionsJpaRepository;
        this.campaignScenarioJpaRepository = campaignScenarioJpaRepository;
        this.entityManager = entityManager;
    }

    public String save(GwtTestCase testCase) {
        if (this.testCaseDoesNotExist(testCase.id())) {
            this.saveScenarioWithExplicitId(testCase);
            return testCase.id();
        }
        try {
            return ((Scenario)this.scenarioJpaRepository.save(Scenario.fromGwtTestCase(testCase))).getId().toString();
        }
        catch (ObjectOptimisticLockingFailureException e) {
            throw new ScenarioNotFoundException(testCase.id(), testCase.metadata().version());
        }
    }

    @Transactional(readOnly=true)
    public Optional<GwtTestCase> findById(String scenarioId) {
        if (this.checkIdInput(scenarioId)) {
            return Optional.empty();
        }
        Optional<Scenario> scenarioDao = this.scenarioJpaRepository.findByIdAndActivated(Long.valueOf(scenarioId), true).filter(Scenario::isActivated);
        return scenarioDao.map(Scenario::toGwtTestCase);
    }

    @Transactional(readOnly=true)
    public Optional<TestCase> findExecutableById(String id) {
        return this.findById(id).map(TestCase.class::cast);
    }

    @Transactional(readOnly=true)
    public Optional<TestCaseMetadata> findMetadataById(String testCaseId) {
        if (this.checkIdInput(testCaseId)) {
            return Optional.empty();
        }
        return this.scenarioJpaRepository.findMetaDataByIdAndActivated(Long.valueOf(testCaseId), true).map(Scenario::toTestCaseMetadata);
    }

    @Transactional(readOnly=true)
    public List<TestCaseMetadata> findAll() {
        return this.scenarioJpaRepository.findMetaDataByActivatedTrue().stream().map(Scenario::toTestCaseMetadata).toList();
    }

    public void removeById(String scenarioId) {
        if (this.checkIdInput(scenarioId)) {
            return;
        }
        this.scenarioJpaRepository.findByIdAndActivated(Long.valueOf(scenarioId), true).ifPresent(scenarioJpa -> {
            List<ScenarioExecution> allExecutions = this.scenarioExecutionsJpaRepository.findAllByScenarioId(scenarioId);
            allExecutions.forEach(e -> {
                e.forCampaignExecution(null);
                this.scenarioExecutionsJpaRepository.save(e);
            });
            List<CampaignScenario> allCampaignScenarios = this.campaignScenarioJpaRepository.findAllByScenarioId(scenarioId);
            this.campaignScenarioJpaRepository.deleteAll(allCampaignScenarios);
            scenarioJpa.deactivate();
            this.scenarioJpaRepository.save(scenarioJpa);
        });
    }

    @Transactional(readOnly=true)
    public Optional<Integer> lastVersion(String scenarioId) {
        if (this.checkIdInput(scenarioId)) {
            return Optional.empty();
        }
        try {
            return this.scenarioJpaRepository.lastVersion(Long.valueOf(scenarioId));
        }
        catch (IncorrectResultSizeDataAccessException e) {
            return Optional.empty();
        }
    }

    @Transactional(readOnly=true)
    public List<TestCaseMetadata> search(String textFilter) {
        if (!textFilter.isEmpty()) {
            List<String> words = this.getWordsToSearchWithQuotes(DatabaseTestCaseRepository.escapeSql(textFilter));
            Specification<Scenario> scenarioDaoSpecification = this.buildLikeSpecificationOnContent(words);
            CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(Scenario.class);
            Root root = query.from(Scenario.class);
            query.select((Selection)builder.construct(Scenario.class, new Selection[]{root.get("id"), root.get("title"), root.get("description"), root.get("tags"), root.get("creationDate"), root.get("dataset"), root.get("activated"), root.get("userId"), root.get("updateDate"), root.get("version"), root.get("defaultDataset")}));
            query = query.where((Expression)scenarioDaoSpecification.toPredicate(root, query, builder));
            return this.entityManager.createQuery(query).getResultList().stream().map(Scenario::toTestCaseMetadata).toList();
        }
        return this.findAll();
    }

    private boolean testCaseDoesNotExist(String id) {
        try {
            return Long.parseLong(id) >= 0L && this.findById(id).isEmpty();
        }
        catch (NumberFormatException e) {
            throw new ScenarioNotParsableException("Cannot parse id", (Exception)e);
        }
    }

    List<String> getWordsToSearchWithQuotes(String input) {
        ArrayList<String> words = new ArrayList<String>();
        Matcher matcher = this.pattern.matcher(input);
        while (matcher.find()) {
            String word = matcher.group(1);
            if (word.isEmpty()) continue;
            words.add(word);
        }
        words.addAll(Arrays.stream(input.replaceAll(this.pattern.pattern(), "").split("\\s")).filter(value -> !value.isEmpty()).toList());
        return words;
    }

    private void saveScenarioWithExplicitId(GwtTestCase testCase) {
        Scenario scenario = Scenario.fromGwtTestCase(testCase);
        this.scenarioJpaRepository.saveWithExplicitId(scenario.getId(), scenario.getTitle(), scenario.getDescription(), scenario.getContent(), scenario.getTags(), scenario.getCreationDate(), scenario.getDataset(), scenario.isActivated(), scenario.getUserId(), scenario.getUpdateDate(), scenario.getVersion(), scenario.getDefaultDataset());
    }

    private static String escapeSql(String str) {
        if (str == null) {
            return null;
        }
        return str.replace("'", "''");
    }

    private Specification<Scenario> buildLikeSpecificationOnContent(List<String> words) {
        Specification<Scenario> scenarioDaoSpecification = null;
        for (String word : words) {
            Specification<Scenario> wordSpecification = ScenarioJpaRepository.contentContains(word);
            scenarioDaoSpecification = Optional.ofNullable(scenarioDaoSpecification).map(s -> s.or(wordSpecification)).orElse(wordSpecification);
        }
        return scenarioDaoSpecification;
    }

    private boolean checkIdInput(String scenarioId) {
        return Strings.isNullOrEmpty((String)scenarioId) || !StringUtils.isNumeric((CharSequence)scenarioId);
    }
}

