/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.infra.storage.jpa;

import com.chutneytesting.execution.infra.storage.jpa.ScenarioExecution;
import com.chutneytesting.server.core.domain.execution.history.ExecutionHistory;
import com.chutneytesting.server.core.domain.execution.history.ImmutableExecutionHistory;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Optional;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapsId;
import javax.persistence.OneToOne;
import javax.persistence.Version;

@Entity(name="SCENARIO_EXECUTIONS_REPORTS")
public class ScenarioExecutionReport {
    @Id
    @Column(name="SCENARIO_EXECUTION_ID")
    private Long scenarioExecutionId;
    @OneToOne(fetch=FetchType.LAZY)
    @MapsId
    @JoinColumn(name="SCENARIO_EXECUTION_ID")
    private ScenarioExecution scenarioExecution;
    @Column(name="REPORT")
    @Basic(fetch=FetchType.LAZY)
    private String report;
    @Column(name="VERSION")
    @Version
    private Integer version;

    public ScenarioExecutionReport() {
    }

    public ScenarioExecutionReport(ScenarioExecution scenarioExecution, String report) {
        this.scenarioExecutionId = scenarioExecution.id();
        this.scenarioExecution = scenarioExecution;
        this.report = report;
    }

    public void updateReport(ExecutionHistory.Execution execution) {
        this.report = execution.report();
    }

    public ExecutionHistory.Execution toDomain() {
        return ImmutableExecutionHistory.Execution.builder().executionId(this.scenarioExecutionId).time(Instant.ofEpochMilli(this.scenarioExecution.executionTime()).atZone(ZoneId.systemDefault()).toLocalDateTime()).duration(this.scenarioExecution.duration().longValue()).status(this.scenarioExecution.status()).info(Optional.ofNullable(this.scenarioExecution.information())).error(Optional.ofNullable(this.scenarioExecution.error())).report(this.report).testCaseTitle(this.scenarioExecution.scenarioTitle()).environment(this.scenarioExecution.environment()).user(this.scenarioExecution.userId()).datasetId(Optional.ofNullable(this.scenarioExecution.datasetId())).datasetVersion(Optional.ofNullable(this.scenarioExecution.datasetVersion())).build();
    }
}

