/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.scenario.domain.raw;

import com.chutneytesting.server.core.domain.scenario.TestCase;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadata;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadataImpl;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RawTestCase
implements TestCase {
    public final TestCaseMetadataImpl metadata;
    public final String scenario;
    private final Map<String, String> executionParameters;

    public RawTestCase(TestCaseMetadataImpl metadata, String scenario, Map<String, String> executionParameters) {
        this.metadata = metadata;
        this.scenario = scenario;
        this.executionParameters = executionParameters;
    }

    public TestCaseMetadata metadata() {
        return this.metadata;
    }

    public Map<String, String> executionParameters() {
        return this.executionParameters;
    }

    public TestCase usingExecutionParameters(Map<String, String> parameters) {
        return RawTestCase.builder().withMetadata(this.metadata).withScenario(this.scenario).withExecutionParameters(parameters).build();
    }

    public String toString() {
        return "RawTestCase{metadata=" + this.metadata + ", scenario=" + this.scenario + ", executionParameters=" + this.executionParameters + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawTestCase that = (RawTestCase)o;
        return Objects.equals(this.metadata, that.metadata) && Objects.equals(this.scenario, that.scenario) && Objects.equals(this.executionParameters, that.executionParameters);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.scenario, this.executionParameters);
    }

    public static RawTestCaseBuilder builder() {
        return new RawTestCaseBuilder();
    }

    public static class RawTestCaseBuilder {
        private TestCaseMetadataImpl metadata;
        private String scenario;
        private Map<String, String> executionParameters;

        private RawTestCaseBuilder() {
        }

        public RawTestCase build() {
            return new RawTestCase(Optional.ofNullable(this.metadata).orElseGet(() -> TestCaseMetadataImpl.builder().build()), Optional.ofNullable(this.scenario).orElse(""), Optional.ofNullable(this.executionParameters).orElse(Collections.emptyMap()));
        }

        public RawTestCaseBuilder withMetadata(TestCaseMetadataImpl metadata) {
            this.metadata = metadata;
            return this;
        }

        public RawTestCaseBuilder withScenario(String scenario) {
            this.scenario = scenario;
            return this;
        }

        public RawTestCaseBuilder withExecutionParameters(Map<String, String> parameters) {
            this.executionParameters = Collections.unmodifiableMap(parameters);
            return this;
        }
    }
}

