/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.infra.storage;

import com.chutneytesting.campaign.infra.CampaignExecutionJpaRepository;
import com.chutneytesting.campaign.infra.CampaignJpaRepository;
import com.chutneytesting.campaign.infra.jpa.Campaign;
import com.chutneytesting.campaign.infra.jpa.CampaignExecution;
import com.chutneytesting.execution.infra.storage.DatabaseExecutionJpaRepository;
import com.chutneytesting.execution.infra.storage.ScenarioExecutionReportJpaRepository;
import com.chutneytesting.execution.infra.storage.jpa.ScenarioExecution;
import com.chutneytesting.execution.infra.storage.jpa.ScenarioExecutionReport;
import com.chutneytesting.scenario.infra.raw.ScenarioJpaRepository;
import com.chutneytesting.server.core.domain.execution.history.ExecutionHistory;
import com.chutneytesting.server.core.domain.execution.history.ExecutionHistoryRepository;
import com.chutneytesting.server.core.domain.execution.history.ImmutableExecutionHistory;
import com.chutneytesting.server.core.domain.execution.report.ReportNotFoundException;
import com.chutneytesting.server.core.domain.execution.report.ServerReportStatus;
import com.chutneytesting.server.core.domain.scenario.TestCaseRepository;
import com.chutneytesting.server.core.domain.scenario.campaign.CampaignExecutionReport;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
class DatabaseExecutionHistoryRepository
implements ExecutionHistoryRepository {
    private final DatabaseExecutionJpaRepository scenarioExecutionsJpaRepository;
    private final ScenarioExecutionReportJpaRepository scenarioExecutionReportJpaRepository;
    private final CampaignJpaRepository campaignJpaRepository;
    private final CampaignExecutionJpaRepository campaignExecutionJpaRepository;
    private final TestCaseRepository testCaseRepository;

    DatabaseExecutionHistoryRepository(DatabaseExecutionJpaRepository scenarioExecutionsJpaRepository, ScenarioExecutionReportJpaRepository scenarioExecutionReportJpaRepository, ScenarioJpaRepository scenarioJpaRepository, CampaignJpaRepository campaignJpaRepository, TestCaseRepository testCaseRepository, CampaignExecutionJpaRepository campaignExecutionJpaRepository) {
        this.scenarioExecutionsJpaRepository = scenarioExecutionsJpaRepository;
        this.scenarioExecutionReportJpaRepository = scenarioExecutionReportJpaRepository;
        this.campaignJpaRepository = campaignJpaRepository;
        this.testCaseRepository = testCaseRepository;
        this.campaignExecutionJpaRepository = campaignExecutionJpaRepository;
    }

    @Transactional(readOnly=true)
    public Map<String, ExecutionHistory.ExecutionSummary> getLastExecutions(List<String> scenarioIds) {
        List<String> scenarioIdL = scenarioIds.stream().filter(id -> !this.invalidScenarioId((String)id)).toList();
        Iterable lastExecutions = this.scenarioExecutionsJpaRepository.findAllById(this.scenarioExecutionsJpaRepository.findLastExecutionsByScenarioId(scenarioIdL).stream().map(t -> (Long)t.get(0, Long.class)).toList());
        return StreamSupport.stream(lastExecutions.spliterator(), true).collect(Collectors.toMap(ScenarioExecution::scenarioId, ScenarioExecution::toDomain));
    }

    @Transactional(readOnly=true)
    public List<ExecutionHistory.ExecutionSummary> getExecutions(String scenarioId) {
        if (this.invalidScenarioId(scenarioId)) {
            return Collections.emptyList();
        }
        List<ScenarioExecution> scenarioExecutions = this.scenarioExecutionsJpaRepository.findFirst20ByScenarioIdOrderByIdDesc(scenarioId);
        return scenarioExecutions.stream().map(this::scenarioExecutionToExecutionSummary).toList();
    }

    @Transactional(readOnly=true)
    public ExecutionHistory.ExecutionSummary getExecutionSummary(Long executionId) {
        return this.scenarioExecutionsJpaRepository.findById(executionId).map(this::scenarioExecutionToExecutionSummary).orElseThrow(() -> new ReportNotFoundException(executionId));
    }

    private ExecutionHistory.ExecutionSummary scenarioExecutionToExecutionSummary(ScenarioExecution scenarioExecution) {
        CampaignExecutionReport campaignExecutionReport = Optional.ofNullable(scenarioExecution.campaignExecution()).map(ce -> ce.toDomain((Campaign)this.campaignJpaRepository.findById(ce.campaignId()).get(), false, null)).orElse(null);
        return scenarioExecution.toDomain(campaignExecutionReport);
    }

    public ExecutionHistory.Execution store(String scenarioId, ExecutionHistory.DetachedExecution detachedExecution) throws IllegalStateException {
        if (this.invalidScenarioId(scenarioId)) {
            throw new IllegalStateException("Scenario id is null or empty");
        }
        ScenarioExecution scenarioExecution = ScenarioExecution.fromDomain(scenarioId, (ExecutionHistory.ExecutionProperties)detachedExecution);
        if (detachedExecution.campaignReport().isPresent()) {
            Optional campaignExecution = this.campaignExecutionJpaRepository.findById((long)((CampaignExecutionReport)detachedExecution.campaignReport().get()).executionId);
            scenarioExecution.forCampaignExecution((CampaignExecution)campaignExecution.get());
        }
        scenarioExecution = (ScenarioExecution)this.scenarioExecutionsJpaRepository.save(scenarioExecution);
        this.scenarioExecutionReportJpaRepository.save(new ScenarioExecutionReport(scenarioExecution, detachedExecution.report()));
        ExecutionHistory.Execution execution = detachedExecution.attach(scenarioExecution.id().longValue());
        return ImmutableExecutionHistory.Execution.builder().from(execution).build();
    }

    @Transactional(readOnly=true)
    public ExecutionHistory.Execution getExecution(String scenarioId, Long reportId) throws ReportNotFoundException {
        if (this.invalidScenarioId(scenarioId) || this.testCaseRepository.findById(scenarioId).isEmpty()) {
            throw new ReportNotFoundException(scenarioId, reportId);
        }
        return this.scenarioExecutionReportJpaRepository.findById(reportId).map(ScenarioExecutionReport::toDomain).orElseThrow(() -> new ReportNotFoundException(scenarioId, reportId));
    }

    public void update(String scenarioId, ExecutionHistory.Execution updatedExecution) throws ReportNotFoundException {
        if (!this.scenarioExecutionsJpaRepository.existsById(updatedExecution.executionId())) {
            throw new ReportNotFoundException(scenarioId, updatedExecution.executionId());
        }
        this.update(updatedExecution);
    }

    private void update(ExecutionHistory.Execution updatedExecution) throws ReportNotFoundException {
        ScenarioExecution execution = (ScenarioExecution)this.scenarioExecutionsJpaRepository.findById(updatedExecution.executionId()).orElseThrow(() -> new ReportNotFoundException(updatedExecution.executionId()));
        execution.updateFromExecution(updatedExecution);
        this.scenarioExecutionsJpaRepository.save(execution);
        this.updateReport(updatedExecution);
    }

    private void updateReport(ExecutionHistory.Execution execution) throws ReportNotFoundException {
        ScenarioExecutionReport scenarioExecutionReport = (ScenarioExecutionReport)this.scenarioExecutionReportJpaRepository.findById(execution.executionId()).orElseThrow(() -> new ReportNotFoundException(execution.executionId()));
        scenarioExecutionReport.updateReport(execution);
        this.scenarioExecutionReportJpaRepository.save(scenarioExecutionReport);
    }

    public int setAllRunningExecutionsToKO() {
        List<ExecutionHistory.ExecutionSummary> runningExecutions = this.getExecutionsWithStatus(ServerReportStatus.RUNNING);
        this.updateExecutionsToKO(runningExecutions);
        List<ExecutionHistory.ExecutionSummary> pausedExecutions = this.getExecutionsWithStatus(ServerReportStatus.PAUSED);
        this.updateExecutionsToKO(pausedExecutions);
        return runningExecutions.size() + pausedExecutions.size();
    }

    @Transactional(readOnly=true)
    public List<ExecutionHistory.ExecutionSummary> getExecutionsWithStatus(ServerReportStatus status) {
        return this.scenarioExecutionsJpaRepository.findByStatus(status).stream().map(ScenarioExecution::toDomain).toList();
    }

    private void updateExecutionsToKO(List<ExecutionHistory.ExecutionSummary> executions) {
        executions.stream().map(this::buildKnockoutExecutionFrom).forEach(this::update);
    }

    private ImmutableExecutionHistory.Execution buildKnockoutExecutionFrom(ExecutionHistory.ExecutionSummary executionSummary) {
        return ImmutableExecutionHistory.Execution.builder().executionId(executionSummary.executionId()).status(ServerReportStatus.FAILURE).time(executionSummary.time()).duration(executionSummary.duration()).info(executionSummary.info()).error("Execution was interrupted !").report("").testCaseTitle(executionSummary.testCaseTitle()).environment(executionSummary.environment()).user(executionSummary.user()).build();
    }

    private boolean invalidScenarioId(String scenarioId) {
        return Strings.isNullOrEmpty((String)scenarioId);
    }
}

