/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.campaign.domain;

import com.chutneytesting.campaign.domain.Frequency;
import java.time.LocalDateTime;
import java.util.Objects;

public class PeriodicScheduledCampaign {
    public final Long id;
    public final Long campaignId;
    public final String campaignTitle;
    public final LocalDateTime nextExecutionDate;
    public final Frequency frequency;

    public PeriodicScheduledCampaign(Long id, Long campaignId, String campaignTitle, LocalDateTime nextExecutionDate, Frequency frequency) {
        this.id = id;
        this.campaignId = campaignId;
        this.campaignTitle = campaignTitle;
        this.nextExecutionDate = nextExecutionDate;
        this.frequency = frequency;
    }

    public PeriodicScheduledCampaign(Long id, Long campaignId, String campaignTitle, LocalDateTime nextExecutionDate) {
        this(id, campaignId, campaignTitle, nextExecutionDate, Frequency.EMPTY);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PeriodicScheduledCampaign that = (PeriodicScheduledCampaign)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.campaignId, that.campaignId) && Objects.equals(this.campaignTitle, that.campaignTitle) && Objects.equals(this.nextExecutionDate, that.nextExecutionDate) && Objects.equals((Object)this.frequency, (Object)that.frequency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.campaignId, this.campaignTitle, this.nextExecutionDate, this.frequency});
    }

    public String toString() {
        return "SchedulingCampaign{id=" + this.id + ", campaignId=" + this.campaignId + ", campaignTitle='" + this.campaignTitle + "', schedulingDate=" + this.nextExecutionDate + ", frequency='" + this.frequency + "'}";
    }

    public PeriodicScheduledCampaign nextScheduledExecution() {
        LocalDateTime scheduledDate = switch (this.frequency) {
            case Frequency.HOURLY -> this.nextExecutionDate.plusHours(1L);
            case Frequency.DAILY -> this.nextExecutionDate.plusDays(1L);
            case Frequency.WEEKLY -> this.nextExecutionDate.plusWeeks(1L);
            case Frequency.MONTHLY -> this.nextExecutionDate.plusMonths(1L);
            default -> throw new IllegalStateException("Unexpected value: " + this.frequency);
        };
        return new PeriodicScheduledCampaign(this.id, this.campaignId, this.campaignTitle, scheduledDate, this.frequency);
    }
}

