/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.admin.domain;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class Backup {
    public static final DateTimeFormatter backupIdTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    public final LocalDateTime time;
    public final List<String> backupables;

    public Backup(List<String> backupables) {
        if (CollectionUtils.isEmpty(backupables)) {
            throw new IllegalArgumentException("Nothing to backup !!");
        }
        this.time = this.getLocalDateTime();
        this.backupables = backupables;
    }

    public Backup(String id, List<String> backupables) {
        this.time = this.toLocalDate(id);
        this.backupables = backupables;
    }

    private LocalDateTime toLocalDate(String id) {
        return StringUtils.isNotBlank((CharSequence)id) ? LocalDateTime.parse(id, backupIdTimeFormatter) : this.getLocalDateTime();
    }

    private LocalDateTime getLocalDateTime() {
        return LocalDateTime.now().truncatedTo(ChronoUnit.SECONDS);
    }

    public String getId() {
        return this.time.format(backupIdTimeFormatter);
    }
}

