package com.chutneytesting.scenario.api.raw.dto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GwtStepDto}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGwtStepDto.builder()}.
 */
@Generated(from = "GwtStepDto", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGwtStepDto implements GwtStepDto {
  private final @Nullable String sentence;
  private final List<GwtStepDto> subSteps;
  private final @Nullable GwtStepImplementationDto implementation;
  private final @Nullable StrategyDto strategy;
  private final @Nullable String xRef;

  private ImmutableGwtStepDto(
      @Nullable String sentence,
      List<GwtStepDto> subSteps,
      @Nullable GwtStepImplementationDto implementation,
      @Nullable StrategyDto strategy,
      @Nullable String xRef) {
    this.sentence = sentence;
    this.subSteps = subSteps;
    this.implementation = implementation;
    this.strategy = strategy;
    this.xRef = xRef;
  }

  /**
   * @return The value of the {@code sentence} attribute
   */
  @JsonProperty("sentence")
  @Override
  public Optional<String> sentence() {
    return Optional.ofNullable(sentence);
  }

  /**
   * @return The value of the {@code subSteps} attribute
   */
  @JsonProperty("subSteps")
  @Override
  public List<GwtStepDto> subSteps() {
    return subSteps;
  }

  /**
   * @return The value of the {@code implementation} attribute
   */
  @JsonProperty("implementation")
  @Override
  public Optional<GwtStepImplementationDto> implementation() {
    return Optional.ofNullable(implementation);
  }

  /**
   * @return The value of the {@code strategy} attribute
   */
  @JsonProperty("strategy")
  @Override
  public Optional<StrategyDto> strategy() {
    return Optional.ofNullable(strategy);
  }

  /**
   * @return The value of the {@code xRef} attribute
   */
  @JsonProperty("x-$ref")
  @Override
  public Optional<String> xRef() {
    return Optional.ofNullable(xRef);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link GwtStepDto#sentence() sentence} attribute.
   * @param value The value for sentence
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGwtStepDto withSentence(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "sentence");
    if (Objects.equals(this.sentence, newValue)) return this;
    return new ImmutableGwtStepDto(newValue, this.subSteps, this.implementation, this.strategy, this.xRef);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link GwtStepDto#sentence() sentence} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for sentence
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGwtStepDto withSentence(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.sentence, value)) return this;
    return new ImmutableGwtStepDto(value, this.subSteps, this.implementation, this.strategy, this.xRef);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GwtStepDto#subSteps() subSteps}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGwtStepDto withSubSteps(GwtStepDto... elements) {
    List<GwtStepDto> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableGwtStepDto(this.sentence, newValue, this.implementation, this.strategy, this.xRef);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GwtStepDto#subSteps() subSteps}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of subSteps elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGwtStepDto withSubSteps(Iterable<? extends GwtStepDto> elements) {
    if (this.subSteps == elements) return this;
    List<GwtStepDto> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableGwtStepDto(this.sentence, newValue, this.implementation, this.strategy, this.xRef);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link GwtStepDto#implementation() implementation} attribute.
   * @param value The value for implementation
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGwtStepDto withImplementation(GwtStepImplementationDto value) {
    @Nullable GwtStepImplementationDto newValue = Objects.requireNonNull(value, "implementation");
    if (this.implementation == newValue) return this;
    return new ImmutableGwtStepDto(this.sentence, this.subSteps, newValue, this.strategy, this.xRef);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link GwtStepDto#implementation() implementation} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for implementation
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableGwtStepDto withImplementation(Optional<? extends GwtStepImplementationDto> optional) {
    @Nullable GwtStepImplementationDto value = optional.orElse(null);
    if (this.implementation == value) return this;
    return new ImmutableGwtStepDto(this.sentence, this.subSteps, value, this.strategy, this.xRef);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link GwtStepDto#strategy() strategy} attribute.
   * @param value The value for strategy
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGwtStepDto withStrategy(StrategyDto value) {
    @Nullable StrategyDto newValue = Objects.requireNonNull(value, "strategy");
    if (this.strategy == newValue) return this;
    return new ImmutableGwtStepDto(this.sentence, this.subSteps, this.implementation, newValue, this.xRef);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link GwtStepDto#strategy() strategy} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for strategy
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableGwtStepDto withStrategy(Optional<? extends StrategyDto> optional) {
    @Nullable StrategyDto value = optional.orElse(null);
    if (this.strategy == value) return this;
    return new ImmutableGwtStepDto(this.sentence, this.subSteps, this.implementation, value, this.xRef);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link GwtStepDto#xRef() xRef} attribute.
   * @param value The value for xRef
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGwtStepDto withXRef(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "xRef");
    if (Objects.equals(this.xRef, newValue)) return this;
    return new ImmutableGwtStepDto(this.sentence, this.subSteps, this.implementation, this.strategy, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link GwtStepDto#xRef() xRef} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for xRef
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGwtStepDto withXRef(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.xRef, value)) return this;
    return new ImmutableGwtStepDto(this.sentence, this.subSteps, this.implementation, this.strategy, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGwtStepDto} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGwtStepDto
        && equalTo(0, (ImmutableGwtStepDto) another);
  }

  private boolean equalTo(int synthetic, ImmutableGwtStepDto another) {
    return Objects.equals(sentence, another.sentence)
        && subSteps.equals(another.subSteps)
        && Objects.equals(implementation, another.implementation)
        && Objects.equals(strategy, another.strategy)
        && Objects.equals(xRef, another.xRef);
  }

  /**
   * Computes a hash code from attributes: {@code sentence}, {@code subSteps}, {@code implementation}, {@code strategy}, {@code xRef}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(sentence);
    h += (h << 5) + subSteps.hashCode();
    h += (h << 5) + Objects.hashCode(implementation);
    h += (h << 5) + Objects.hashCode(strategy);
    h += (h << 5) + Objects.hashCode(xRef);
    return h;
  }

  /**
   * Prints the immutable value {@code GwtStepDto} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("GwtStepDto{");
    if (sentence != null) {
      builder.append("sentence=").append(sentence);
    }
    if (builder.length() > 11) builder.append(", ");
    builder.append("subSteps=").append(subSteps);
    if (implementation != null) {
      builder.append(", ");
      builder.append("implementation=").append(implementation);
    }
    if (strategy != null) {
      builder.append(", ");
      builder.append("strategy=").append(strategy);
    }
    if (xRef != null) {
      builder.append(", ");
      builder.append("xRef=").append(xRef);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "GwtStepDto", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements GwtStepDto {
    @Nullable Optional<String> sentence = Optional.empty();
    @Nullable List<GwtStepDto> subSteps = Collections.emptyList();
    @Nullable Optional<GwtStepImplementationDto> implementation = Optional.empty();
    @Nullable Optional<StrategyDto> strategy = Optional.empty();
    @Nullable Optional<String> xRef = Optional.empty();
    @JsonProperty("sentence")
    public void setSentence(Optional<String> sentence) {
      this.sentence = sentence;
    }
    @JsonProperty("subSteps")
    public void setSubSteps(List<GwtStepDto> subSteps) {
      this.subSteps = subSteps;
    }
    @JsonProperty("implementation")
    public void setImplementation(Optional<GwtStepImplementationDto> implementation) {
      this.implementation = implementation;
    }
    @JsonProperty("strategy")
    public void setStrategy(Optional<StrategyDto> strategy) {
      this.strategy = strategy;
    }
    @JsonProperty("x-$ref")
    public void setXRef(Optional<String> xRef) {
      this.xRef = xRef;
    }
    @Override
    public Optional<String> sentence() { throw new UnsupportedOperationException(); }
    @Override
    public List<GwtStepDto> subSteps() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<GwtStepImplementationDto> implementation() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<StrategyDto> strategy() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> xRef() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableGwtStepDto fromJson(Json json) {
    ImmutableGwtStepDto.Builder builder = ImmutableGwtStepDto.builder();
    if (json.sentence != null) {
      builder.sentence(json.sentence);
    }
    if (json.subSteps != null) {
      builder.addAllSubSteps(json.subSteps);
    }
    if (json.implementation != null) {
      builder.implementation(json.implementation);
    }
    if (json.strategy != null) {
      builder.strategy(json.strategy);
    }
    if (json.xRef != null) {
      builder.xRef(json.xRef);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link GwtStepDto} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GwtStepDto instance
   */
  public static ImmutableGwtStepDto copyOf(GwtStepDto instance) {
    if (instance instanceof ImmutableGwtStepDto) {
      return (ImmutableGwtStepDto) instance;
    }
    return ImmutableGwtStepDto.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGwtStepDto ImmutableGwtStepDto}.
   * <pre>
   * ImmutableGwtStepDto.builder()
   *    .sentence(String) // optional {@link GwtStepDto#sentence() sentence}
   *    .addSubSteps|addAllSubSteps(com.chutneytesting.scenario.api.raw.dto.GwtStepDto) // {@link GwtStepDto#subSteps() subSteps} elements
   *    .implementation(com.chutneytesting.scenario.api.raw.dto.GwtStepImplementationDto) // optional {@link GwtStepDto#implementation() implementation}
   *    .strategy(com.chutneytesting.scenario.api.raw.dto.StrategyDto) // optional {@link GwtStepDto#strategy() strategy}
   *    .xRef(String) // optional {@link GwtStepDto#xRef() xRef}
   *    .build();
   * </pre>
   * @return A new ImmutableGwtStepDto builder
   */
  public static ImmutableGwtStepDto.Builder builder() {
    return new ImmutableGwtStepDto.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGwtStepDto ImmutableGwtStepDto}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GwtStepDto", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String sentence;
    private List<GwtStepDto> subSteps = new ArrayList<GwtStepDto>();
    private @Nullable GwtStepImplementationDto implementation;
    private @Nullable StrategyDto strategy;
    private @Nullable String xRef;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GwtStepDto} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GwtStepDto instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> sentenceOptional = instance.sentence();
      if (sentenceOptional.isPresent()) {
        sentence(sentenceOptional);
      }
      addAllSubSteps(instance.subSteps());
      Optional<GwtStepImplementationDto> implementationOptional = instance.implementation();
      if (implementationOptional.isPresent()) {
        implementation(implementationOptional);
      }
      Optional<StrategyDto> strategyOptional = instance.strategy();
      if (strategyOptional.isPresent()) {
        strategy(strategyOptional);
      }
      Optional<String> xRefOptional = instance.xRef();
      if (xRefOptional.isPresent()) {
        xRef(xRefOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link GwtStepDto#sentence() sentence} to sentence.
     * @param sentence The value for sentence
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sentence(String sentence) {
      this.sentence = Objects.requireNonNull(sentence, "sentence");
      return this;
    }

    /**
     * Initializes the optional value {@link GwtStepDto#sentence() sentence} to sentence.
     * @param sentence The value for sentence
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("sentence")
    public final Builder sentence(Optional<String> sentence) {
      this.sentence = sentence.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link GwtStepDto#subSteps() subSteps} list.
     * @param element A subSteps element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSubSteps(GwtStepDto element) {
      this.subSteps.add(Objects.requireNonNull(element, "subSteps element"));
      return this;
    }

    /**
     * Adds elements to {@link GwtStepDto#subSteps() subSteps} list.
     * @param elements An array of subSteps elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSubSteps(GwtStepDto... elements) {
      for (GwtStepDto element : elements) {
        this.subSteps.add(Objects.requireNonNull(element, "subSteps element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GwtStepDto#subSteps() subSteps} list.
     * @param elements An iterable of subSteps elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("subSteps")
    public final Builder subSteps(Iterable<? extends GwtStepDto> elements) {
      this.subSteps.clear();
      return addAllSubSteps(elements);
    }

    /**
     * Adds elements to {@link GwtStepDto#subSteps() subSteps} list.
     * @param elements An iterable of subSteps elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllSubSteps(Iterable<? extends GwtStepDto> elements) {
      for (GwtStepDto element : elements) {
        this.subSteps.add(Objects.requireNonNull(element, "subSteps element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link GwtStepDto#implementation() implementation} to implementation.
     * @param implementation The value for implementation
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder implementation(GwtStepImplementationDto implementation) {
      this.implementation = Objects.requireNonNull(implementation, "implementation");
      return this;
    }

    /**
     * Initializes the optional value {@link GwtStepDto#implementation() implementation} to implementation.
     * @param implementation The value for implementation
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("implementation")
    public final Builder implementation(Optional<? extends GwtStepImplementationDto> implementation) {
      this.implementation = implementation.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link GwtStepDto#strategy() strategy} to strategy.
     * @param strategy The value for strategy
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder strategy(StrategyDto strategy) {
      this.strategy = Objects.requireNonNull(strategy, "strategy");
      return this;
    }

    /**
     * Initializes the optional value {@link GwtStepDto#strategy() strategy} to strategy.
     * @param strategy The value for strategy
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("strategy")
    public final Builder strategy(Optional<? extends StrategyDto> strategy) {
      this.strategy = strategy.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link GwtStepDto#xRef() xRef} to xRef.
     * @param xRef The value for xRef
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder xRef(String xRef) {
      this.xRef = Objects.requireNonNull(xRef, "xRef");
      return this;
    }

    /**
     * Initializes the optional value {@link GwtStepDto#xRef() xRef} to xRef.
     * @param xRef The value for xRef
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("x-$ref")
    public final Builder xRef(Optional<String> xRef) {
      this.xRef = xRef.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableGwtStepDto ImmutableGwtStepDto}.
     * @return An immutable instance of GwtStepDto
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGwtStepDto build() {
      return new ImmutableGwtStepDto(sentence, createUnmodifiableList(true, subSteps), implementation, strategy, xRef);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
