/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.security.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public final class UserDto
implements UserDetails {
    private String id;
    private String name;
    private String firstname;
    private String lastname;
    private String mail;
    @JsonIgnore
    private Set<String> roles;
    private Set<GrantedAuthority> authorizations;
    @JsonIgnore
    private String password;

    public UserDto() {
    }

    public UserDto(UserDto copyFrom) {
        this.id = copyFrom.getId();
        this.name = copyFrom.getName();
        this.firstname = copyFrom.getFirstname();
        this.lastname = copyFrom.getLastname();
        this.mail = copyFrom.getMail();
        this.roles = new HashSet<String>(copyFrom.getRoles());
        this.authorizations = new HashSet<GrantedAuthority>(copyFrom.getAuthorities());
        this.password = copyFrom.getPassword();
    }

    @JsonIgnore
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return Optional.ofNullable(this.authorizations).orElse(Collections.emptySet());
    }

    public Collection<String> getAuthorizations() {
        return Optional.ofNullable(this.authorizations).map(a -> a.stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    public String getPassword() {
        return this.password;
    }

    @JsonIgnore
    public String getUsername() {
        return this.id;
    }

    @JsonIgnore
    public boolean isAccountNonExpired() {
        return true;
    }

    @JsonIgnore
    public boolean isAccountNonLocked() {
        return true;
    }

    @JsonIgnore
    public boolean isCredentialsNonExpired() {
        return true;
    }

    @JsonIgnore
    public boolean isEnabled() {
        return true;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public String getMail() {
        return this.mail;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    public Set<String> getRoles() {
        return Optional.ofNullable(this.roles).orElse(Collections.emptySet());
    }

    public void setRoles(Set<String> roles) {
        roles.forEach(this::addRole);
    }

    public void addRole(String role) {
        if (this.roles == null) {
            this.roles = new HashSet<String>();
        }
        this.roles.add(role);
    }

    public void grantAuthority(String authority) {
        if (this.authorizations == null) {
            this.authorizations = new HashSet<GrantedAuthority>();
        }
        this.authorizations.add((GrantedAuthority)new SimpleGrantedAuthority(authority));
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

