/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.execution.domain.campaign;

import com.chutneytesting.campaign.domain.CampaignNotFoundException;
import com.chutneytesting.campaign.domain.CampaignRepository;
import com.chutneytesting.execution.domain.campaign.CampaignAlreadyRunningException;
import com.chutneytesting.execution.domain.campaign.CampaignExecutionNotFoundException;
import com.chutneytesting.execution.domain.campaign.JiraReportMapper;
import com.chutneytesting.jira.api.JiraXrayEmbeddedApi;
import com.chutneytesting.scenario.domain.TestCaseRepositoryAggregator;
import com.chutneytesting.server.core.domain.dataset.DataSetHistoryRepository;
import com.chutneytesting.server.core.domain.execution.ExecutionRequest;
import com.chutneytesting.server.core.domain.execution.FailedExecutionAttempt;
import com.chutneytesting.server.core.domain.execution.ScenarioExecutionEngine;
import com.chutneytesting.server.core.domain.execution.history.ExecutionHistory;
import com.chutneytesting.server.core.domain.execution.history.ExecutionHistoryRepository;
import com.chutneytesting.server.core.domain.execution.report.ScenarioExecutionReport;
import com.chutneytesting.server.core.domain.execution.report.ServerReportStatus;
import com.chutneytesting.server.core.domain.instrument.ChutneyMetrics;
import com.chutneytesting.server.core.domain.scenario.ScenarioNotFoundException;
import com.chutneytesting.server.core.domain.scenario.ScenarioNotParsableException;
import com.chutneytesting.server.core.domain.scenario.TestCase;
import com.chutneytesting.server.core.domain.scenario.campaign.Campaign;
import com.chutneytesting.server.core.domain.scenario.campaign.CampaignExecutionReport;
import com.chutneytesting.server.core.domain.scenario.campaign.ScenarioExecutionReportCampaign;
import com.chutneytesting.tools.Try;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CampaignExecutionEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(Campaign.class);
    private final ExecutorService executor;
    private final CampaignRepository campaignRepository;
    private final ScenarioExecutionEngine scenarioExecutionEngine;
    private final ExecutionHistoryRepository executionHistoryRepository;
    private final TestCaseRepositoryAggregator testCaseRepository;
    private final DataSetHistoryRepository dataSetHistoryRepository;
    private final JiraXrayEmbeddedApi jiraXrayEmbeddedApi;
    private final ChutneyMetrics metrics;
    private final Map<Long, CampaignExecutionReport> currentCampaignExecutions = new ConcurrentHashMap<Long, CampaignExecutionReport>();
    private final Map<Long, Boolean> currentCampaignExecutionsStopRequests = new ConcurrentHashMap<Long, Boolean>();
    private final ObjectMapper objectMapper;

    public CampaignExecutionEngine(CampaignRepository campaignRepository, ScenarioExecutionEngine scenarioExecutionEngine, ExecutionHistoryRepository executionHistoryRepository, TestCaseRepositoryAggregator testCaseRepository, Optional<DataSetHistoryRepository> dataSetHistoryRepository, JiraXrayEmbeddedApi jiraXrayEmbeddedApi, ChutneyMetrics metrics, ExecutorService executorService, ObjectMapper objectMapper) {
        this.campaignRepository = campaignRepository;
        this.scenarioExecutionEngine = scenarioExecutionEngine;
        this.executionHistoryRepository = executionHistoryRepository;
        this.testCaseRepository = testCaseRepository;
        this.dataSetHistoryRepository = dataSetHistoryRepository.orElse(null);
        this.jiraXrayEmbeddedApi = jiraXrayEmbeddedApi;
        this.metrics = metrics;
        this.executor = executorService;
        this.objectMapper = objectMapper;
    }

    public List<CampaignExecutionReport> executeByName(String campaignName, String userId) {
        return this.executeByName(campaignName, null, userId);
    }

    public List<CampaignExecutionReport> executeByName(String campaignName, String environment, String userId) {
        List<Campaign> campaigns = this.campaignRepository.findByName(campaignName);
        return campaigns.stream().map(campaign -> this.selectExecutionEnvironment((Campaign)campaign, environment)).map(campaign -> this.executeCampaign((Campaign)campaign, userId)).collect(Collectors.toList());
    }

    public CampaignExecutionReport executeById(Long campaignId, String userId) {
        return this.executeById(campaignId, null, userId);
    }

    public CampaignExecutionReport executeById(Long campaignId, String environment, String userId) {
        return Optional.ofNullable(this.campaignRepository.findById(campaignId)).map(campaign -> this.selectExecutionEnvironment((Campaign)campaign, environment)).map(campaign -> this.executeCampaign((Campaign)campaign, userId)).orElseThrow(() -> new CampaignNotFoundException(campaignId));
    }

    public Optional<CampaignExecutionReport> currentExecution(Long campaignId) {
        return Optional.ofNullable(campaignId).map(id -> this.currentCampaignExecutions.get(campaignId));
    }

    public List<CampaignExecutionReport> currentExecutions() {
        return new ArrayList<CampaignExecutionReport>(this.currentCampaignExecutions.values());
    }

    public void stopExecution(Long executionId) {
        LOGGER.trace("Stop requested for " + executionId);
        Optional.ofNullable(this.currentCampaignExecutionsStopRequests.computeIfPresent(executionId, (aLong, aBoolean) -> Boolean.TRUE)).orElseThrow(() -> new CampaignExecutionNotFoundException(executionId));
    }

    public CampaignExecutionReport executeScenarioInCampaign(List<String> failedIds, Campaign campaign, String userId) {
        CampaignExecutionReport campaignExecutionReport;
        CampaignExecutionReport campaignExecutionReport2;
        Long executionId;
        block5: {
            this.verifyNotAlreadyRunning(campaign);
            executionId = this.campaignRepository.newCampaignExecution();
            campaignExecutionReport2 = new CampaignExecutionReport(executionId, campaign.title, !failedIds.isEmpty(), campaign.executionEnvironment(), StringUtils.isNotBlank((CharSequence)campaign.externalDatasetId) ? campaign.externalDatasetId : null, StringUtils.isNotBlank((CharSequence)campaign.externalDatasetId) ? this.dataSetHistoryRepository.lastVersion(campaign.externalDatasetId) : null, userId);
            this.currentCampaignExecutions.put(campaign.id, campaignExecutionReport2);
            this.currentCampaignExecutionsStopRequests.put(executionId, Boolean.FALSE);
            if (!failedIds.isEmpty()) break block5;
            CampaignExecutionReport campaignExecutionReport3 = this.execute(campaign, campaignExecutionReport2, campaign.scenarioIds);
            campaignExecutionReport2.endCampaignExecution();
            LOGGER.info("Save campaign {} execution {} with status {}", new Object[]{campaign.id, campaignExecutionReport2.executionId, campaignExecutionReport2.status()});
            this.currentCampaignExecutionsStopRequests.remove(executionId);
            this.currentCampaignExecutions.remove(campaign.id);
            Try.exec(() -> {
                this.campaignRepository.saveReport(campaign.id, campaignExecutionReport2);
                return null;
            }).ifFailed(e -> LOGGER.error("Error saving report of campaign {} execution {}", (Object)campaign.id, (Object)campaignExecutionReport.executionId));
            Try.exec(() -> {
                this.metrics.onCampaignExecutionEnded(campaign, campaignExecutionReport2);
                return null;
            }).ifFailed(e -> LOGGER.error("Error saving metrics for campaign {} execution {}", (Object)campaign.id, (Object)campaignExecutionReport.executionId));
            return campaignExecutionReport3;
        }
        try {
            campaignExecutionReport = this.execute(campaign, campaignExecutionReport2, failedIds);
        }
        catch (Exception e2) {
            try {
                LOGGER.error("Not managed exception occurred", (Throwable)e2);
                throw new RuntimeException(e2);
            }
            catch (Throwable throwable) {
                campaignExecutionReport2.endCampaignExecution();
                LOGGER.info("Save campaign {} execution {} with status {}", new Object[]{campaign.id, campaignExecutionReport2.executionId, campaignExecutionReport2.status()});
                this.currentCampaignExecutionsStopRequests.remove(executionId);
                this.currentCampaignExecutions.remove(campaign.id);
                Try.exec(() -> {
                    this.campaignRepository.saveReport(campaign.id, campaignExecutionReport2);
                    return null;
                }).ifFailed(e -> LOGGER.error("Error saving report of campaign {} execution {}", (Object)campaign.id, (Object)campaignExecutionReport.executionId));
                Try.exec(() -> {
                    this.metrics.onCampaignExecutionEnded(campaign, campaignExecutionReport2);
                    return null;
                }).ifFailed(e -> LOGGER.error("Error saving metrics for campaign {} execution {}", (Object)campaign.id, (Object)campaignExecutionReport.executionId));
                throw throwable;
            }
        }
        campaignExecutionReport2.endCampaignExecution();
        LOGGER.info("Save campaign {} execution {} with status {}", new Object[]{campaign.id, campaignExecutionReport2.executionId, campaignExecutionReport2.status()});
        this.currentCampaignExecutionsStopRequests.remove(executionId);
        this.currentCampaignExecutions.remove(campaign.id);
        Try.exec(() -> {
            this.campaignRepository.saveReport(campaign.id, campaignExecutionReport2);
            return null;
        }).ifFailed(e -> LOGGER.error("Error saving report of campaign {} execution {}", (Object)campaign.id, (Object)campaignExecutionReport.executionId));
        Try.exec(() -> {
            this.metrics.onCampaignExecutionEnded(campaign, campaignExecutionReport2);
            return null;
        }).ifFailed(e -> LOGGER.error("Error saving metrics for campaign {} execution {}", (Object)campaign.id, (Object)campaignExecutionReport.executionId));
        return campaignExecutionReport;
    }

    private CampaignExecutionReport execute(Campaign campaign, CampaignExecutionReport campaignExecutionReport, List<String> scenariosToExecute) {
        LOGGER.trace("Execute campaign {} : {}", (Object)campaign.id, (Object)campaign.title);
        List testCases = scenariosToExecute.stream().map(this.testCaseRepository::findExecutableById).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        campaignExecutionReport.initExecution(testCases, campaign.executionEnvironment(), campaignExecutionReport.userId);
        try {
            if (campaign.parallelRun) {
                ArrayList toExecute = Lists.newArrayList();
                for (TestCase t : testCases) {
                    toExecute.add(Executors.callable(() -> this.executeScenarioInCampaign(campaign, campaignExecutionReport).accept(t)));
                }
                this.executor.invokeAll(toExecute);
            } else {
                for (TestCase t : testCases) {
                    this.executor.invokeAll(Collections.singleton(Executors.callable(() -> this.executeScenarioInCampaign(campaign, campaignExecutionReport).accept(t))));
                }
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Error ", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error ", (Throwable)e);
        }
        return campaignExecutionReport;
    }

    private Consumer<TestCase> executeScenarioInCampaign(Campaign campaign, CampaignExecutionReport campaignExecutionReport) {
        return testCase -> {
            if (!this.currentCampaignExecutionsStopRequests.get(campaignExecutionReport.executionId).booleanValue()) {
                campaignExecutionReport.startScenarioExecution(testCase, campaign.executionEnvironment(), campaignExecutionReport.userId);
                ScenarioExecutionReportCampaign scenarioExecutionReport = this.executeScenario(campaign, (TestCase)testCase, campaignExecutionReport.userId);
                if (campaign.retryAuto && ServerReportStatus.FAILURE.equals((Object)scenarioExecutionReport.status())) {
                    scenarioExecutionReport = this.executeScenario(campaign, (TestCase)testCase, campaignExecutionReport.userId);
                }
                Optional.ofNullable(scenarioExecutionReport).ifPresent(serc -> {
                    campaignExecutionReport.endScenarioExecution(serc);
                    ExecutionHistory.Execution execution = this.executionHistoryRepository.getExecution(serc.scenarioId, serc.execution.executionId());
                    this.jiraXrayEmbeddedApi.updateTestExecution(campaign.id, campaignExecutionReport.executionId, serc.scenarioId, JiraReportMapper.from(execution.report(), this.objectMapper));
                });
            }
        };
    }

    private ScenarioExecutionReportCampaign executeScenario(Campaign campaign, TestCase testCase, String userId) {
        String scenarioName;
        Long executionId;
        try {
            LOGGER.trace("Execute scenario {} for campaign {}", (Object)testCase.id(), (Object)campaign.id);
            ExecutionRequest executionRequest = this.buildExecutionRequest(campaign, testCase, userId);
            ScenarioExecutionReport scenarioExecutionReport = this.scenarioExecutionEngine.execute(executionRequest, Optional.empty());
            executionId = scenarioExecutionReport.executionId;
            scenarioName = scenarioExecutionReport.scenarioName;
        }
        catch (FailedExecutionAttempt e) {
            LOGGER.warn("Failed execution attempt for scenario {} for campaign {}", (Object)testCase.id(), (Object)campaign.id);
            executionId = e.executionId;
            scenarioName = e.title;
        }
        catch (ScenarioNotFoundException | ScenarioNotParsableException se) {
            LOGGER.error("Scenario error for scenario {} for campaign {}", new Object[]{testCase.id(), campaign.id, se});
            return null;
        }
        ExecutionHistory.Execution execution = this.executionHistoryRepository.getExecution(testCase.id(), executionId);
        return new ScenarioExecutionReportCampaign(testCase.id(), scenarioName, execution.summary());
    }

    private ExecutionRequest buildExecutionRequest(Campaign campaign, TestCase testCase, String userId) {
        if (StringUtils.isNotBlank((CharSequence)campaign.externalDatasetId) && testCase.id().contains("-")) {
            return this.executionWithDatasetIdOverrideByCampaign(campaign, testCase, userId);
        }
        return this.executionWithCombinedParametersFromCampaignAndTestCase(campaign, testCase, userId);
    }

    private ExecutionRequest executionWithDatasetIdOverrideByCampaign(Campaign campaign, TestCase testCase, String userId) {
        return new ExecutionRequest(testCase.withDataSetId(campaign.externalDatasetId), campaign.executionEnvironment(), userId);
    }

    private ExecutionRequest executionWithCombinedParametersFromCampaignAndTestCase(Campaign campaign, TestCase testCase, String userId) {
        HashMap executionParameters = new HashMap(testCase.executionParameters());
        executionParameters.putAll(campaign.executionParameters);
        return new ExecutionRequest(testCase.usingExecutionParameters(executionParameters), campaign.executionEnvironment(), userId);
    }

    private CampaignExecutionReport executeCampaign(Campaign campaign, String userId) {
        return this.executeScenarioInCampaign(Collections.emptyList(), campaign, userId);
    }

    private void verifyNotAlreadyRunning(Campaign campaign) {
        Optional<CampaignExecutionReport> currentReport = this.currentExecution(campaign.id);
        if (currentReport.isPresent() && !currentReport.get().status().isFinal()) {
            throw new CampaignAlreadyRunningException(currentReport.get());
        }
    }

    private Campaign selectExecutionEnvironment(Campaign campaign, String environment) {
        Optional.ofNullable(environment).ifPresent(arg_0 -> ((Campaign)campaign).executionEnvironment(arg_0));
        return campaign;
    }
}

