/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.admin.infra;

import com.chutneytesting.admin.domain.Backup;
import com.chutneytesting.admin.domain.BackupNotFoundException;
import com.chutneytesting.admin.domain.BackupRepository;
import com.chutneytesting.server.core.domain.admin.Backupable;
import com.chutneytesting.server.core.domain.tools.ZipUtils;
import com.chutneytesting.tools.Try;
import com.chutneytesting.tools.file.FileUtils;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.FileSystemUtils;

@Component
public class FileSystemBackupRepository
implements BackupRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemBackupRepository.class);
    static final Path ROOT_DIRECTORY_NAME = Paths.get("backups", "zip");
    static final String BACKUP_FILE_EXTENSION = ".zip";
    private final Path backupsRootPath;
    private final List<Backupable> backupables;

    public FileSystemBackupRepository(@Value(value="${chutney.configuration-folder:~/.chutney/conf}") String backupsRootPath, List<Backupable> backupables) {
        this.backupsRootPath = Paths.get(backupsRootPath, new String[0]).resolve(ROOT_DIRECTORY_NAME).toAbsolutePath();
        FileUtils.initFolder((Path)this.backupsRootPath);
        this.backupables = backupables;
    }

    @Override
    public void getBackupData(String backupId, OutputStream outputStream) throws IOException {
        Path backupPath = this.backupsRootPath.resolve(backupId);
        try (ZipOutputStream zipOutPut = new ZipOutputStream(new BufferedOutputStream(outputStream, 4096));){
            ZipUtils.compressDirectoryToZipfile((Path)backupPath.getParent(), (Path)Paths.get(backupId, new String[0]), (ZipOutputStream)zipOutPut);
        }
        catch (FileNotFoundException fnfe) {
            throw new BackupNotFoundException(backupId);
        }
    }

    @Override
    public List<String> getBackupables() {
        return this.backupables.stream().map(Backupable::name).collect(Collectors.toList());
    }

    @Override
    public String save(Backup backup) {
        String backupId = backup.getId();
        LOGGER.info("Backup [{}] initiating", (Object)backupId);
        Path backupPath = this.backupsRootPath.resolve(backupId);
        Try.exec(() -> Files.createDirectory(backupPath, new FileAttribute[0])).runtime();
        this.backupables.stream().filter(backupable -> backup.backupables.contains(backupable.name())).forEach(backupable -> this.backup(backupPath, (Backupable)backupable));
        LOGGER.info("Backup [{}] completed", (Object)backupId);
        return backup.getId();
    }

    @Override
    public Backup read(String backupId) {
        Path backupPath = this.backupsRootPath.resolve(backupId);
        if (backupPath.toFile().exists()) {
            try {
                List<String> foundBackupables = this.backupables.stream().map(backupable -> backupable.name()).filter(backupName -> backupPath.resolve(backupName + BACKUP_FILE_EXTENSION).toFile().exists()).collect(Collectors.toList());
                return new Backup(backupId, foundBackupables);
            }
            catch (RuntimeException re) {
                throw new BackupNotFoundException(backupId);
            }
        }
        throw new BackupNotFoundException(backupId);
    }

    @Override
    public void delete(String backupId) {
        Path backupPath = this.backupsRootPath.resolve(backupId);
        if (!Files.exists(backupPath, new LinkOption[0])) {
            throw new BackupNotFoundException(backupId);
        }
        Try.exec(() -> FileSystemUtils.deleteRecursively((Path)backupPath)).runtime();
        LOGGER.info("Backup [{}] deleted", (Object)backupId);
    }

    @Override
    public List<Backup> list() {
        ArrayList<Backup> backups = new ArrayList<Backup>();
        FileUtils.doOnListFiles((Path)this.backupsRootPath, pathStream -> {
            pathStream.forEach(path -> {
                try {
                    backups.add(this.read(path.getFileName().toString()));
                }
                catch (BackupNotFoundException bnfe) {
                    LOGGER.warn("Ignoring unparsable backup [{}]", (Object)path.getFileName().toString(), (Object)bnfe);
                }
            });
            return Void.TYPE;
        });
        backups.sort(Comparator.comparing(b -> ((Backup)b).time).reversed());
        return backups;
    }

    private void backup(Path packupPath, Backupable backupable) {
        try (OutputStream outputStream = Files.newOutputStream(packupPath.resolve(backupable.name() + BACKUP_FILE_EXTENSION), new OpenOption[0]);){
            backupable.backup(outputStream);
        }
        catch (Exception e) {
            LOGGER.error("Cannot backup [{}]", (Object)backupable.name(), (Object)e);
        }
        LOGGER.info("Backup [{}] completed", (Object)backupable.name());
    }
}

