/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.admin.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/info"})
@CrossOrigin(origins={"*"})
public class InfoController {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoController.class);
    public static final String BASE_URL = "/api/v1/info";
    private final Properties buildProperties = this.loadBuildProperties();
    @Value(value="${server.instance-name:''}")
    private String applicationName;

    private Properties loadBuildProperties() {
        Properties props = new Properties();
        try (InputStream input = InfoController.class.getClassLoader().getResourceAsStream("META-INF/build.properties");){
            if (input != null) {
                props.load(input);
            }
        }
        catch (IOException ioe) {
            LOGGER.warn("Cannot read build properties file", (Throwable)ioe);
        }
        return props;
    }

    @GetMapping(path={"/build/version"})
    public String buildVersion() {
        return this.buildProperties.getProperty("build.version", "");
    }

    @GetMapping(path={"/appname"})
    public String applicationName() {
        return this.applicationName;
    }
}

