/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.scenario.domain.gwt;

import com.chutneytesting.scenario.domain.gwt.GwtScenario;
import com.chutneytesting.server.core.domain.scenario.TestCase;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadata;
import com.chutneytesting.server.core.domain.scenario.TestCaseMetadataImpl;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class GwtTestCase
implements TestCase {
    public final TestCaseMetadataImpl metadata;
    public final GwtScenario scenario;
    public final Map<String, String> executionParameters;

    private GwtTestCase(TestCaseMetadataImpl metadata, GwtScenario scenario, Map<String, String> executionParameters) {
        this.metadata = metadata;
        this.scenario = scenario;
        this.executionParameters = executionParameters;
    }

    public TestCaseMetadata metadata() {
        return this.metadata;
    }

    public Map<String, String> executionParameters() {
        return this.executionParameters;
    }

    public TestCase usingExecutionParameters(Map<String, String> parameters) {
        return GwtTestCase.builder().withMetadata(this.metadata).withScenario(this.scenario).withExecutionParameters(parameters).build();
    }

    public String toString() {
        return "GwtTestCase{metadata=" + this.metadata + ", scenario=" + this.scenario + ", executionParameters=" + this.executionParameters + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GwtTestCase that = (GwtTestCase)o;
        return this.metadata.equals((Object)that.metadata) && this.scenario.equals(that.scenario) && this.executionParameters.equals(that.executionParameters);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.scenario, this.executionParameters);
    }

    public static GwtTestCaseBuilder builder() {
        return new GwtTestCaseBuilder();
    }

    public static class GwtTestCaseBuilder {
        private TestCaseMetadataImpl metadata;
        private GwtScenario scenario;
        private Map<String, String> executionParameters;

        private GwtTestCaseBuilder() {
        }

        public GwtTestCase build() {
            return new GwtTestCase(this.metadata, this.scenario, Optional.ofNullable(this.executionParameters).orElse(Collections.emptyMap()));
        }

        public GwtTestCaseBuilder withMetadata(TestCaseMetadataImpl metadata) {
            this.metadata = metadata;
            return this;
        }

        public GwtTestCaseBuilder withScenario(GwtScenario scenario) {
            this.scenario = scenario;
            return this;
        }

        public GwtTestCaseBuilder withExecutionParameters(Map<String, String> parameters) {
            this.executionParameters = Collections.unmodifiableMap(parameters);
            return this;
        }

        public GwtTestCaseBuilder from(GwtTestCase testCase) {
            this.withMetadata(testCase.metadata);
            this.withScenario(testCase.scenario);
            this.withExecutionParameters(testCase.executionParameters);
            return this;
        }
    }
}

