/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.scenario.api;

import com.chutneytesting.execution.api.ExecutionSummaryDto;
import com.chutneytesting.scenario.api.raw.dto.TestCaseIndexDto;
import com.chutneytesting.server.core.domain.execution.history.ExecutionHistoryRepository;
import com.chutneytesting.server.core.domain.scenario.ScenarioNotFoundException;
import com.chutneytesting.server.core.domain.scenario.TestCase;
import com.chutneytesting.server.core.domain.scenario.TestCaseRepository;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/api/scenario/v2"})
public class AggregatedTestCaseController {
    private TestCaseRepository testCaseRepository;
    private final ExecutionHistoryRepository executionHistoryRepository;

    public AggregatedTestCaseController(TestCaseRepository testCaseRepository, ExecutionHistoryRepository executionHistoryRepository) {
        this.testCaseRepository = testCaseRepository;
        this.executionHistoryRepository = executionHistoryRepository;
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_READ')")
    @GetMapping(path={"/{testCaseId}/metadata"}, produces={"application/json"})
    public TestCaseIndexDto testCaseMetaData(@PathVariable(value="testCaseId") String testCaseId) {
        TestCase testCase = (TestCase)this.testCaseRepository.findById(testCaseId).orElseThrow(() -> new ScenarioNotFoundException(testCaseId));
        return TestCaseIndexDto.from(testCase.metadata(), Collections.emptyList());
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_READ') or hasAuthority('CAMPAIGN_WRITE')")
    @GetMapping(path={""}, produces={"application/json"})
    public List<TestCaseIndexDto> getTestCases(@RequestParam(name="textFilter", required=false) String textFilter) {
        List testCases = Strings.isNullOrEmpty((String)textFilter) ? this.testCaseRepository.findAll() : this.testCaseRepository.search(textFilter);
        return testCases.stream().map(tc -> {
            List<ExecutionSummaryDto> executions = ExecutionSummaryDto.toDto(this.executionHistoryRepository.getExecutions(tc.id()));
            return TestCaseIndexDto.from(tc, executions);
        }).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_WRITE')")
    @DeleteMapping(path={"/{testCaseId}"})
    public void removeScenarioById(@PathVariable(value="testCaseId") String testCaseId) {
        this.testCaseRepository.removeById(testCaseId);
    }
}

