package com.chutneytesting.execution.api;

import com.chutneytesting.server.core.domain.execution.history.ExecutionHistory;
import com.chutneytesting.server.core.domain.execution.report.ServerReportStatus;
import com.chutneytesting.server.core.domain.scenario.campaign.CampaignExecutionReport;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExecutionSummaryDto}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExecutionSummaryDto.builder()}.
 */
@Generated(from = "ExecutionSummaryDto", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableExecutionSummaryDto
    implements ExecutionSummaryDto {
  private final LocalDateTime time;
  private final long duration;
  private final ServerReportStatus status;
  private final @Nullable String info;
  private final @Nullable String error;
  private final String testCaseTitle;
  private final String environment;
  private final @Nullable String datasetId;
  private final @Nullable Integer datasetVersion;
  private final String user;
  private final @Nullable CampaignExecutionReport campaignReport;
  private final Long executionId;

  private ImmutableExecutionSummaryDto(
      LocalDateTime time,
      long duration,
      ServerReportStatus status,
      @Nullable String info,
      @Nullable String error,
      String testCaseTitle,
      String environment,
      @Nullable String datasetId,
      @Nullable Integer datasetVersion,
      String user,
      @Nullable CampaignExecutionReport campaignReport,
      Long executionId) {
    this.time = time;
    this.duration = duration;
    this.status = status;
    this.info = info;
    this.error = error;
    this.testCaseTitle = testCaseTitle;
    this.environment = environment;
    this.datasetId = datasetId;
    this.datasetVersion = datasetVersion;
    this.user = user;
    this.campaignReport = campaignReport;
    this.executionId = executionId;
  }

  /**
   * @return The value of the {@code time} attribute
   */
  @JsonProperty("time")
  @Override
  public LocalDateTime time() {
    return time;
  }

  /**
   * @return The value of the {@code duration} attribute
   */
  @JsonProperty("duration")
  @Override
  public long duration() {
    return duration;
  }

  /**
   * @return The value of the {@code status} attribute
   */
  @JsonProperty("status")
  @Override
  public ServerReportStatus status() {
    return status;
  }

  /**
   * @return The value of the {@code info} attribute
   */
  @JsonProperty("info")
  @Override
  public Optional<String> info() {
    return Optional.ofNullable(info);
  }

  /**
   * @return The value of the {@code error} attribute
   */
  @JsonProperty("error")
  @Override
  public Optional<String> error() {
    return Optional.ofNullable(error);
  }

  /**
   * @return The value of the {@code testCaseTitle} attribute
   */
  @JsonProperty("testCaseTitle")
  @Override
  public String testCaseTitle() {
    return testCaseTitle;
  }

  /**
   * @return The value of the {@code environment} attribute
   */
  @JsonProperty("environment")
  @Override
  public String environment() {
    return environment;
  }

  /**
   * @return The value of the {@code datasetId} attribute
   */
  @JsonProperty("datasetId")
  @Override
  public Optional<String> datasetId() {
    return Optional.ofNullable(datasetId);
  }

  /**
   * @return The value of the {@code datasetVersion} attribute
   */
  @JsonProperty("datasetVersion")
  @Override
  public Optional<Integer> datasetVersion() {
    return Optional.ofNullable(datasetVersion);
  }

  /**
   * @return The value of the {@code user} attribute
   */
  @JsonProperty("user")
  @Override
  public String user() {
    return user;
  }

  /**
   * @return The value of the {@code campaignReport} attribute
   */
  @JsonProperty("campaignReport")
  @Override
  public Optional<CampaignExecutionReport> campaignReport() {
    return Optional.ofNullable(campaignReport);
  }

  /**
   * @return The value of the {@code executionId} attribute
   */
  @JsonProperty("executionId")
  @Override
  public Long executionId() {
    return executionId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExecutionSummaryDto#time() time} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for time
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExecutionSummaryDto withTime(LocalDateTime value) {
    if (this.time == value) return this;
    LocalDateTime newValue = Objects.requireNonNull(value, "time");
    return new ImmutableExecutionSummaryDto(
        newValue,
        this.duration,
        this.status,
        this.info,
        this.error,
        this.testCaseTitle,
        this.environment,
        this.datasetId,
        this.datasetVersion,
        this.user,
        this.campaignReport,
        this.executionId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExecutionSummaryDto#duration() duration} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for duration
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExecutionSummaryDto withDuration(long value) {
    if (this.duration == value) return this;
    return new ImmutableExecutionSummaryDto(
        this.time,
        value,
        this.status,
        this.info,
        this.error,
        this.testCaseTitle,
        this.environment,
        this.datasetId,
        this.datasetVersion,
        this.user,
        this.campaignReport,
        this.executionId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExecutionSummaryDto#status() status} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExecutionSummaryDto withStatus(ServerReportStatus value) {
    ServerReportStatus newValue = Objects.requireNonNull(value, "status");
    if (this.status == newValue) return this;
    return new ImmutableExecutionSummaryDto(
        this.time,
        this.duration,
        newValue,
        this.info,
        this.error,
        this.testCaseTitle,
        this.environment,
        this.datasetId,
        this.datasetVersion,
        this.user,
        this.campaignReport,
        this.executionId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ExecutionSummaryDto#info() info} attribute.
   * @param value The value for info
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExecutionSummaryDto withInfo(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "info");
    if (Objects.equals(this.info, newValue)) return this;
    return new ImmutableExecutionSummaryDto(
        this.time,
        this.duration,
        this.status,
        newValue,
        this.error,
        this.testCaseTitle,
        this.environment,
        this.datasetId,
        this.datasetVersion,
        this.user,
        this.campaignReport,
        this.executionId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ExecutionSummaryDto#info() info} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for info
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExecutionSummaryDto withInfo(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.info, value)) return this;
    return new ImmutableExecutionSummaryDto(
        this.time,
        this.duration,
        this.status,
        value,
        this.error,
        this.testCaseTitle,
        this.environment,
        this.datasetId,
        this.datasetVersion,
        this.user,
        this.campaignReport,
        this.executionId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ExecutionSummaryDto#error() error} attribute.
   * @param value The value for error
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExecutionSummaryDto withError(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "error");
    if (Objects.equals(this.error, newValue)) return this;
    return new ImmutableExecutionSummaryDto(
        this.time,
        this.duration,
        this.status,
        this.info,
        newValue,
        this.testCaseTitle,
        this.environment,
        this.datasetId,
        this.datasetVersion,
        this.user,
        this.campaignReport,
        this.executionId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ExecutionSummaryDto#error() error} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for error
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExecutionSummaryDto withError(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.error, value)) return this;
    return new ImmutableExecutionSummaryDto(
        this.time,
        this.duration,
        this.status,
        this.info,
        value,
        this.testCaseTitle,
        this.environment,
        this.datasetId,
        this.datasetVersion,
        this.user,
        this.campaignReport,
        this.executionId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExecutionSummaryDto#testCaseTitle() testCaseTitle} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for testCaseTitle
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExecutionSummaryDto withTestCaseTitle(String value) {
    String newValue = Objects.requireNonNull(value, "testCaseTitle");
    if (this.testCaseTitle.equals(newValue)) return this;
    return new ImmutableExecutionSummaryDto(
        this.time,
        this.duration,
        this.status,
        this.info,
        this.error,
        newValue,
        this.environment,
        this.datasetId,
        this.datasetVersion,
        this.user,
        this.campaignReport,
        this.executionId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExecutionSummaryDto#environment() environment} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for environment
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExecutionSummaryDto withEnvironment(String value) {
    String newValue = Objects.requireNonNull(value, "environment");
    if (this.environment.equals(newValue)) return this;
    return new ImmutableExecutionSummaryDto(
        this.time,
        this.duration,
        this.status,
        this.info,
        this.error,
        this.testCaseTitle,
        newValue,
        this.datasetId,
        this.datasetVersion,
        this.user,
        this.campaignReport,
        this.executionId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ExecutionSummaryDto#datasetId() datasetId} attribute.
   * @param value The value for datasetId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExecutionSummaryDto withDatasetId(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "datasetId");
    if (Objects.equals(this.datasetId, newValue)) return this;
    return new ImmutableExecutionSummaryDto(
        this.time,
        this.duration,
        this.status,
        this.info,
        this.error,
        this.testCaseTitle,
        this.environment,
        newValue,
        this.datasetVersion,
        this.user,
        this.campaignReport,
        this.executionId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ExecutionSummaryDto#datasetId() datasetId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for datasetId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExecutionSummaryDto withDatasetId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.datasetId, value)) return this;
    return new ImmutableExecutionSummaryDto(
        this.time,
        this.duration,
        this.status,
        this.info,
        this.error,
        this.testCaseTitle,
        this.environment,
        value,
        this.datasetVersion,
        this.user,
        this.campaignReport,
        this.executionId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ExecutionSummaryDto#datasetVersion() datasetVersion} attribute.
   * @param value The value for datasetVersion
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExecutionSummaryDto withDatasetVersion(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.datasetVersion, newValue)) return this;
    return new ImmutableExecutionSummaryDto(
        this.time,
        this.duration,
        this.status,
        this.info,
        this.error,
        this.testCaseTitle,
        this.environment,
        this.datasetId,
        newValue,
        this.user,
        this.campaignReport,
        this.executionId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ExecutionSummaryDto#datasetVersion() datasetVersion} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for datasetVersion
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExecutionSummaryDto withDatasetVersion(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.datasetVersion, value)) return this;
    return new ImmutableExecutionSummaryDto(
        this.time,
        this.duration,
        this.status,
        this.info,
        this.error,
        this.testCaseTitle,
        this.environment,
        this.datasetId,
        value,
        this.user,
        this.campaignReport,
        this.executionId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExecutionSummaryDto#user() user} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for user
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExecutionSummaryDto withUser(String value) {
    String newValue = Objects.requireNonNull(value, "user");
    if (this.user.equals(newValue)) return this;
    return new ImmutableExecutionSummaryDto(
        this.time,
        this.duration,
        this.status,
        this.info,
        this.error,
        this.testCaseTitle,
        this.environment,
        this.datasetId,
        this.datasetVersion,
        newValue,
        this.campaignReport,
        this.executionId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ExecutionSummaryDto#campaignReport() campaignReport} attribute.
   * @param value The value for campaignReport
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExecutionSummaryDto withCampaignReport(CampaignExecutionReport value) {
    @Nullable CampaignExecutionReport newValue = Objects.requireNonNull(value, "campaignReport");
    if (this.campaignReport == newValue) return this;
    return new ImmutableExecutionSummaryDto(
        this.time,
        this.duration,
        this.status,
        this.info,
        this.error,
        this.testCaseTitle,
        this.environment,
        this.datasetId,
        this.datasetVersion,
        this.user,
        newValue,
        this.executionId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ExecutionSummaryDto#campaignReport() campaignReport} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for campaignReport
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableExecutionSummaryDto withCampaignReport(Optional<? extends CampaignExecutionReport> optional) {
    @Nullable CampaignExecutionReport value = optional.orElse(null);
    if (this.campaignReport == value) return this;
    return new ImmutableExecutionSummaryDto(
        this.time,
        this.duration,
        this.status,
        this.info,
        this.error,
        this.testCaseTitle,
        this.environment,
        this.datasetId,
        this.datasetVersion,
        this.user,
        value,
        this.executionId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExecutionSummaryDto#executionId() executionId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for executionId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExecutionSummaryDto withExecutionId(Long value) {
    Long newValue = Objects.requireNonNull(value, "executionId");
    if (this.executionId.equals(newValue)) return this;
    return new ImmutableExecutionSummaryDto(
        this.time,
        this.duration,
        this.status,
        this.info,
        this.error,
        this.testCaseTitle,
        this.environment,
        this.datasetId,
        this.datasetVersion,
        this.user,
        this.campaignReport,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExecutionSummaryDto} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExecutionSummaryDto
        && equalTo(0, (ImmutableExecutionSummaryDto) another);
  }

  private boolean equalTo(int synthetic, ImmutableExecutionSummaryDto another) {
    return time.equals(another.time)
        && duration == another.duration
        && status.equals(another.status)
        && Objects.equals(info, another.info)
        && Objects.equals(error, another.error)
        && testCaseTitle.equals(another.testCaseTitle)
        && environment.equals(another.environment)
        && Objects.equals(datasetId, another.datasetId)
        && Objects.equals(datasetVersion, another.datasetVersion)
        && user.equals(another.user)
        && Objects.equals(campaignReport, another.campaignReport)
        && executionId.equals(another.executionId);
  }

  /**
   * Computes a hash code from attributes: {@code time}, {@code duration}, {@code status}, {@code info}, {@code error}, {@code testCaseTitle}, {@code environment}, {@code datasetId}, {@code datasetVersion}, {@code user}, {@code campaignReport}, {@code executionId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + time.hashCode();
    h += (h << 5) + Longs.hashCode(duration);
    h += (h << 5) + status.hashCode();
    h += (h << 5) + Objects.hashCode(info);
    h += (h << 5) + Objects.hashCode(error);
    h += (h << 5) + testCaseTitle.hashCode();
    h += (h << 5) + environment.hashCode();
    h += (h << 5) + Objects.hashCode(datasetId);
    h += (h << 5) + Objects.hashCode(datasetVersion);
    h += (h << 5) + user.hashCode();
    h += (h << 5) + Objects.hashCode(campaignReport);
    h += (h << 5) + executionId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ExecutionSummaryDto} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ExecutionSummaryDto")
        .omitNullValues()
        .add("time", time)
        .add("duration", duration)
        .add("status", status)
        .add("info", info)
        .add("error", error)
        .add("testCaseTitle", testCaseTitle)
        .add("environment", environment)
        .add("datasetId", datasetId)
        .add("datasetVersion", datasetVersion)
        .add("user", user)
        .add("campaignReport", campaignReport)
        .add("executionId", executionId)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ExecutionSummaryDto", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ExecutionSummaryDto {
    @Nullable LocalDateTime time;
    long duration;
    boolean durationIsSet;
    @Nullable ServerReportStatus status;
    @Nullable Optional<String> info = Optional.empty();
    @Nullable Optional<String> error = Optional.empty();
    @Nullable String testCaseTitle;
    @Nullable String environment;
    @Nullable Optional<String> datasetId = Optional.empty();
    @Nullable Optional<Integer> datasetVersion = Optional.empty();
    @Nullable String user;
    @Nullable Optional<CampaignExecutionReport> campaignReport = Optional.empty();
    @Nullable Long executionId;
    @JsonProperty("time")
    public void setTime(LocalDateTime time) {
      this.time = time;
    }
    @JsonProperty("duration")
    public void setDuration(long duration) {
      this.duration = duration;
      this.durationIsSet = true;
    }
    @JsonProperty("status")
    public void setStatus(ServerReportStatus status) {
      this.status = status;
    }
    @JsonProperty("info")
    public void setInfo(Optional<String> info) {
      this.info = info;
    }
    @JsonProperty("error")
    public void setError(Optional<String> error) {
      this.error = error;
    }
    @JsonProperty("testCaseTitle")
    public void setTestCaseTitle(String testCaseTitle) {
      this.testCaseTitle = testCaseTitle;
    }
    @JsonProperty("environment")
    public void setEnvironment(String environment) {
      this.environment = environment;
    }
    @JsonProperty("datasetId")
    public void setDatasetId(Optional<String> datasetId) {
      this.datasetId = datasetId;
    }
    @JsonProperty("datasetVersion")
    public void setDatasetVersion(Optional<Integer> datasetVersion) {
      this.datasetVersion = datasetVersion;
    }
    @JsonProperty("user")
    public void setUser(String user) {
      this.user = user;
    }
    @JsonProperty("campaignReport")
    public void setCampaignReport(Optional<CampaignExecutionReport> campaignReport) {
      this.campaignReport = campaignReport;
    }
    @JsonProperty("executionId")
    public void setExecutionId(Long executionId) {
      this.executionId = executionId;
    }
    @Override
    public LocalDateTime time() { throw new UnsupportedOperationException(); }
    @Override
    public long duration() { throw new UnsupportedOperationException(); }
    @Override
    public ServerReportStatus status() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> info() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> error() { throw new UnsupportedOperationException(); }
    @Override
    public String testCaseTitle() { throw new UnsupportedOperationException(); }
    @Override
    public String environment() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> datasetId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> datasetVersion() { throw new UnsupportedOperationException(); }
    @Override
    public String user() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<CampaignExecutionReport> campaignReport() { throw new UnsupportedOperationException(); }
    @Override
    public Long executionId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableExecutionSummaryDto fromJson(Json json) {
    ImmutableExecutionSummaryDto.Builder builder = ImmutableExecutionSummaryDto.builder();
    if (json.time != null) {
      builder.time(json.time);
    }
    if (json.durationIsSet) {
      builder.duration(json.duration);
    }
    if (json.status != null) {
      builder.status(json.status);
    }
    if (json.info != null) {
      builder.info(json.info);
    }
    if (json.error != null) {
      builder.error(json.error);
    }
    if (json.testCaseTitle != null) {
      builder.testCaseTitle(json.testCaseTitle);
    }
    if (json.environment != null) {
      builder.environment(json.environment);
    }
    if (json.datasetId != null) {
      builder.datasetId(json.datasetId);
    }
    if (json.datasetVersion != null) {
      builder.datasetVersion(json.datasetVersion);
    }
    if (json.user != null) {
      builder.user(json.user);
    }
    if (json.campaignReport != null) {
      builder.campaignReport(json.campaignReport);
    }
    if (json.executionId != null) {
      builder.executionId(json.executionId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ExecutionSummaryDto} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExecutionSummaryDto instance
   */
  public static ImmutableExecutionSummaryDto copyOf(ExecutionSummaryDto instance) {
    if (instance instanceof ImmutableExecutionSummaryDto) {
      return (ImmutableExecutionSummaryDto) instance;
    }
    return ImmutableExecutionSummaryDto.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExecutionSummaryDto ImmutableExecutionSummaryDto}.
   * <pre>
   * ImmutableExecutionSummaryDto.builder()
   *    .time(java.time.LocalDateTime) // required {@link ExecutionSummaryDto#time() time}
   *    .duration(long) // required {@link ExecutionSummaryDto#duration() duration}
   *    .status(com.chutneytesting.server.core.domain.execution.report.ServerReportStatus) // required {@link ExecutionSummaryDto#status() status}
   *    .info(String) // optional {@link ExecutionSummaryDto#info() info}
   *    .error(String) // optional {@link ExecutionSummaryDto#error() error}
   *    .testCaseTitle(String) // required {@link ExecutionSummaryDto#testCaseTitle() testCaseTitle}
   *    .environment(String) // required {@link ExecutionSummaryDto#environment() environment}
   *    .datasetId(String) // optional {@link ExecutionSummaryDto#datasetId() datasetId}
   *    .datasetVersion(Integer) // optional {@link ExecutionSummaryDto#datasetVersion() datasetVersion}
   *    .user(String) // required {@link ExecutionSummaryDto#user() user}
   *    .campaignReport(com.chutneytesting.server.core.domain.scenario.campaign.CampaignExecutionReport) // optional {@link ExecutionSummaryDto#campaignReport() campaignReport}
   *    .executionId(Long) // required {@link ExecutionSummaryDto#executionId() executionId}
   *    .build();
   * </pre>
   * @return A new ImmutableExecutionSummaryDto builder
   */
  public static ImmutableExecutionSummaryDto.Builder builder() {
    return new ImmutableExecutionSummaryDto.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExecutionSummaryDto ImmutableExecutionSummaryDto}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ExecutionSummaryDto", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TIME = 0x1L;
    private static final long INIT_BIT_DURATION = 0x2L;
    private static final long INIT_BIT_STATUS = 0x4L;
    private static final long INIT_BIT_TEST_CASE_TITLE = 0x8L;
    private static final long INIT_BIT_ENVIRONMENT = 0x10L;
    private static final long INIT_BIT_USER = 0x20L;
    private static final long INIT_BIT_EXECUTION_ID = 0x40L;
    private long initBits = 0x7fL;

    private @Nullable LocalDateTime time;
    private long duration;
    private @Nullable ServerReportStatus status;
    private @Nullable String info;
    private @Nullable String error;
    private @Nullable String testCaseTitle;
    private @Nullable String environment;
    private @Nullable String datasetId;
    private @Nullable Integer datasetVersion;
    private @Nullable String user;
    private @Nullable CampaignExecutionReport campaignReport;
    private @Nullable Long executionId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.chutneytesting.execution.api.ExecutionSummaryDto} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ExecutionSummaryDto instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.chutneytesting.server.core.domain.execution.history.ExecutionHistory.ExecutionProperties} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ExecutionHistory.ExecutionProperties instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.chutneytesting.server.core.domain.execution.history.ExecutionHistory.Attached} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ExecutionHistory.Attached instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof ExecutionSummaryDto) {
        ExecutionSummaryDto instance = (ExecutionSummaryDto) object;
        if ((bits & 0x1L) == 0) {
          duration(instance.duration());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          executionId(instance.executionId());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          environment(instance.environment());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          Optional<Integer> datasetVersionOptional = instance.datasetVersion();
          if (datasetVersionOptional.isPresent()) {
            datasetVersion(datasetVersionOptional);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          Optional<String> datasetIdOptional = instance.datasetId();
          if (datasetIdOptional.isPresent()) {
            datasetId(datasetIdOptional);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          time(instance.time());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          Optional<String> errorOptional = instance.error();
          if (errorOptional.isPresent()) {
            error(errorOptional);
          }
          bits |= 0x40L;
        }
        if ((bits & 0x80L) == 0) {
          testCaseTitle(instance.testCaseTitle());
          bits |= 0x80L;
        }
        if ((bits & 0x100L) == 0) {
          user(instance.user());
          bits |= 0x100L;
        }
        if ((bits & 0x200L) == 0) {
          Optional<CampaignExecutionReport> campaignReportOptional = instance.campaignReport();
          if (campaignReportOptional.isPresent()) {
            campaignReport(campaignReportOptional);
          }
          bits |= 0x200L;
        }
        if ((bits & 0x400L) == 0) {
          status(instance.status());
          bits |= 0x400L;
        }
        if ((bits & 0x800L) == 0) {
          Optional<String> infoOptional = instance.info();
          if (infoOptional.isPresent()) {
            info(infoOptional);
          }
          bits |= 0x800L;
        }
      }
      if (object instanceof ExecutionHistory.ExecutionProperties) {
        ExecutionHistory.ExecutionProperties instance = (ExecutionHistory.ExecutionProperties) object;
        if ((bits & 0x1L) == 0) {
          duration(instance.duration());
          bits |= 0x1L;
        }
        if ((bits & 0x4L) == 0) {
          environment(instance.environment());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          Optional<Integer> datasetVersionOptional = instance.datasetVersion();
          if (datasetVersionOptional.isPresent()) {
            datasetVersion(datasetVersionOptional);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          Optional<String> datasetIdOptional = instance.datasetId();
          if (datasetIdOptional.isPresent()) {
            datasetId(datasetIdOptional);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          time(instance.time());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          Optional<String> errorOptional = instance.error();
          if (errorOptional.isPresent()) {
            error(errorOptional);
          }
          bits |= 0x40L;
        }
        if ((bits & 0x80L) == 0) {
          testCaseTitle(instance.testCaseTitle());
          bits |= 0x80L;
        }
        if ((bits & 0x100L) == 0) {
          user(instance.user());
          bits |= 0x100L;
        }
        if ((bits & 0x200L) == 0) {
          Optional<CampaignExecutionReport> campaignReportOptional = instance.campaignReport();
          if (campaignReportOptional.isPresent()) {
            campaignReport(campaignReportOptional);
          }
          bits |= 0x200L;
        }
        if ((bits & 0x400L) == 0) {
          status(instance.status());
          bits |= 0x400L;
        }
        if ((bits & 0x800L) == 0) {
          Optional<String> infoOptional = instance.info();
          if (infoOptional.isPresent()) {
            info(infoOptional);
          }
          bits |= 0x800L;
        }
      }
      if (object instanceof ExecutionHistory.Attached) {
        ExecutionHistory.Attached instance = (ExecutionHistory.Attached) object;
        if ((bits & 0x2L) == 0) {
          executionId(instance.executionId());
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link ExecutionSummaryDto#time() time} attribute.
     * @param time The value for time 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("time")
    public final Builder time(LocalDateTime time) {
      this.time = Objects.requireNonNull(time, "time");
      initBits &= ~INIT_BIT_TIME;
      return this;
    }

    /**
     * Initializes the value for the {@link ExecutionSummaryDto#duration() duration} attribute.
     * @param duration The value for duration 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("duration")
    public final Builder duration(long duration) {
      this.duration = duration;
      initBits &= ~INIT_BIT_DURATION;
      return this;
    }

    /**
     * Initializes the value for the {@link ExecutionSummaryDto#status() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("status")
    public final Builder status(ServerReportStatus status) {
      this.status = Objects.requireNonNull(status, "status");
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Initializes the optional value {@link ExecutionSummaryDto#info() info} to info.
     * @param info The value for info
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder info(String info) {
      this.info = Objects.requireNonNull(info, "info");
      return this;
    }

    /**
     * Initializes the optional value {@link ExecutionSummaryDto#info() info} to info.
     * @param info The value for info
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("info")
    public final Builder info(Optional<String> info) {
      this.info = info.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ExecutionSummaryDto#error() error} to error.
     * @param error The value for error
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder error(String error) {
      this.error = Objects.requireNonNull(error, "error");
      return this;
    }

    /**
     * Initializes the optional value {@link ExecutionSummaryDto#error() error} to error.
     * @param error The value for error
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("error")
    public final Builder error(Optional<String> error) {
      this.error = error.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ExecutionSummaryDto#testCaseTitle() testCaseTitle} attribute.
     * @param testCaseTitle The value for testCaseTitle 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("testCaseTitle")
    public final Builder testCaseTitle(String testCaseTitle) {
      this.testCaseTitle = Objects.requireNonNull(testCaseTitle, "testCaseTitle");
      initBits &= ~INIT_BIT_TEST_CASE_TITLE;
      return this;
    }

    /**
     * Initializes the value for the {@link ExecutionSummaryDto#environment() environment} attribute.
     * @param environment The value for environment 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("environment")
    public final Builder environment(String environment) {
      this.environment = Objects.requireNonNull(environment, "environment");
      initBits &= ~INIT_BIT_ENVIRONMENT;
      return this;
    }

    /**
     * Initializes the optional value {@link ExecutionSummaryDto#datasetId() datasetId} to datasetId.
     * @param datasetId The value for datasetId
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder datasetId(String datasetId) {
      this.datasetId = Objects.requireNonNull(datasetId, "datasetId");
      return this;
    }

    /**
     * Initializes the optional value {@link ExecutionSummaryDto#datasetId() datasetId} to datasetId.
     * @param datasetId The value for datasetId
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("datasetId")
    public final Builder datasetId(Optional<String> datasetId) {
      this.datasetId = datasetId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ExecutionSummaryDto#datasetVersion() datasetVersion} to datasetVersion.
     * @param datasetVersion The value for datasetVersion
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder datasetVersion(int datasetVersion) {
      this.datasetVersion = datasetVersion;
      return this;
    }

    /**
     * Initializes the optional value {@link ExecutionSummaryDto#datasetVersion() datasetVersion} to datasetVersion.
     * @param datasetVersion The value for datasetVersion
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("datasetVersion")
    public final Builder datasetVersion(Optional<Integer> datasetVersion) {
      this.datasetVersion = datasetVersion.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ExecutionSummaryDto#user() user} attribute.
     * @param user The value for user 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("user")
    public final Builder user(String user) {
      this.user = Objects.requireNonNull(user, "user");
      initBits &= ~INIT_BIT_USER;
      return this;
    }

    /**
     * Initializes the optional value {@link ExecutionSummaryDto#campaignReport() campaignReport} to campaignReport.
     * @param campaignReport The value for campaignReport
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder campaignReport(CampaignExecutionReport campaignReport) {
      this.campaignReport = Objects.requireNonNull(campaignReport, "campaignReport");
      return this;
    }

    /**
     * Initializes the optional value {@link ExecutionSummaryDto#campaignReport() campaignReport} to campaignReport.
     * @param campaignReport The value for campaignReport
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("campaignReport")
    public final Builder campaignReport(Optional<? extends CampaignExecutionReport> campaignReport) {
      this.campaignReport = campaignReport.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ExecutionSummaryDto#executionId() executionId} attribute.
     * @param executionId The value for executionId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("executionId")
    public final Builder executionId(Long executionId) {
      this.executionId = Objects.requireNonNull(executionId, "executionId");
      initBits &= ~INIT_BIT_EXECUTION_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableExecutionSummaryDto ImmutableExecutionSummaryDto}.
     * @return An immutable instance of ExecutionSummaryDto
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExecutionSummaryDto build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableExecutionSummaryDto(
          time,
          duration,
          status,
          info,
          error,
          testCaseTitle,
          environment,
          datasetId,
          datasetVersion,
          user,
          campaignReport,
          executionId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TIME) != 0) attributes.add("time");
      if ((initBits & INIT_BIT_DURATION) != 0) attributes.add("duration");
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      if ((initBits & INIT_BIT_TEST_CASE_TITLE) != 0) attributes.add("testCaseTitle");
      if ((initBits & INIT_BIT_ENVIRONMENT) != 0) attributes.add("environment");
      if ((initBits & INIT_BIT_USER) != 0) attributes.add("user");
      if ((initBits & INIT_BIT_EXECUTION_ID) != 0) attributes.add("executionId");
      return "Cannot build ExecutionSummaryDto, some of required attributes are not set " + attributes;
    }
  }
}
