/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;

public final class ZipUtils {
    public static void compressFile(File file, String zipEntityName, ZipOutputStream out) throws IOException {
        ZipEntry entry = new ZipEntry(zipEntityName);
        out.putNextEntry(entry);
        try (FileInputStream in = new FileInputStream(file);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }

    public static void compressDirectoryToZipfile(Path rootDir, Path sourceDir, ZipOutputStream out) throws IOException {
        Path dir = rootDir.resolve(sourceDir);
        if (Files.exists(dir, new LinkOption[0])) {
            for (File file : Objects.requireNonNull(dir.toFile().listFiles())) {
                Path source = sourceDir.resolve(file.getName());
                if (file.isDirectory()) {
                    ZipUtils.compressDirectoryToZipfile(rootDir, source, out);
                    continue;
                }
                ZipUtils.compressFile(rootDir.resolve(source).toFile(), source.toString(), out);
            }
        } else {
            throw new FileNotFoundException(dir.toString());
        }
    }
}

