/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.security.infra.memory;

import com.chutneytesting.security.api.UserDto;
import com.chutneytesting.security.domain.AuthenticationService;
import com.chutneytesting.security.infra.memory.InMemoryUsersProperties;
import com.chutneytesting.server.core.domain.security.Authorization;
import com.chutneytesting.server.core.domain.security.Role;
import com.chutneytesting.server.core.domain.security.RoleNotFoundException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class InMemoryUserDetailsService
implements UserDetailsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryUserDetailsService.class);
    private final Map<String, UserDto> users;
    private final AuthenticationService authenticationService;

    public InMemoryUserDetailsService(InMemoryUsersProperties inMemoryUsersProperties, AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
        this.users = inMemoryUsersProperties.getUsers().stream().collect(Collectors.toUnmodifiableMap(UserDto::getUsername, Function.identity()));
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        Optional<UserDto> user = Optional.ofNullable(this.users.get(username));
        return user.map(this::readRole).orElseThrow(() -> new UsernameNotFoundException("Username not found."));
    }

    private UserDto readRole(UserDto userDto) {
        UserDto dto = new UserDto(userDto);
        if (dto.getRoles().contains("ADMIN")) {
            Arrays.stream(Authorization.values()).map(Enum::name).forEach(dto::grantAuthority);
        } else {
            try {
                Role role = this.authenticationService.userRoleById(dto.getId());
                dto.addRole(role.name);
                role.authorizations.stream().map(Enum::name).forEach(dto::grantAuthority);
            }
            catch (RoleNotFoundException rnfe) {
                LOGGER.warn("User {} has no role defined", (Object)dto.getId());
                throw rnfe;
            }
        }
        return dto;
    }
}

