/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.agent.domain.explore;

import com.chutneytesting.agent.domain.TargetId;
import com.chutneytesting.agent.domain.explore.AgentId;
import com.chutneytesting.agent.domain.explore.ImmutableExploreResult;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import org.immutables.value.Value;

@Value.Immutable
@Value.Enclosing
public interface ExploreResult {
    public static final ExploreResult EMPTY = ImmutableExploreResult.of(Links.empty(), Links.empty());

    @Value.Parameter
    public Links<AgentId, AgentId> agentLinks();

    @Value.Parameter
    public Links<AgentId, TargetId> targetLinks();

    @Value.Immutable
    public static interface Link<SOURCE, DESTINATION> {
        @Value.Parameter
        public SOURCE source();

        @Value.Parameter
        public DESTINATION destination();
    }

    @Value.Immutable
    public static interface Links<SOURCE, DESTINATION>
    extends Iterable<Link<SOURCE, DESTINATION>> {
        @Value.Parameter
        public Set<Link<SOURCE, DESTINATION>> links();

        @Override
        default public Iterator<Link<SOURCE, DESTINATION>> iterator() {
            return this.links().iterator();
        }

        default public Stream<Link<SOURCE, DESTINATION>> stream() {
            return this.links().stream();
        }

        public static <S, D> Links<S, D> empty() {
            return ImmutableExploreResult.Links.builder().build();
        }
    }
}

