/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.server.core.domain.security;

import com.chutneytesting.server.core.domain.security.Role;
import com.chutneytesting.server.core.domain.security.RoleNotFoundException;
import com.chutneytesting.server.core.domain.security.User;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class UserRoles {
    private final Map<Role, Set<User>> userRoleMap;

    private UserRoles(Map<Role, Set<User>> userRoleMap) {
        this.userRoleMap = userRoleMap;
    }

    public Optional<User> userById(String userId) {
        return this.users().stream().filter(User.userByIdPredicate(userId)).findFirst();
    }

    public Role roleByName(String roleName) {
        return this.roles().stream().filter(Role.roleByNamePredicate(roleName)).findFirst().orElseThrow(() -> RoleNotFoundException.forRole(roleName));
    }

    public Set<Role> roles() {
        return this.userRoleMap.keySet();
    }

    public Set<User> users() {
        return this.userRoleMap.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<User> usersByRole(Role role) {
        Objects.requireNonNull(role);
        return this.users().stream().filter(User.userByRoleNamePredicate(role.name)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static UserRolesBuilder builder() {
        return new UserRolesBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserRoles userRoles = (UserRoles)o;
        return this.userRoleMap.equals(userRoles.userRoleMap);
    }

    public int hashCode() {
        return Objects.hash(this.userRoleMap);
    }

    public String toString() {
        return "UserRoles{userRoleMap=" + this.userRoleMap + "}";
    }

    public static class UserRolesBuilder {
        private Set<Role> roles = Collections.emptySet();
        private Set<User> users = Collections.emptySet();

        private UserRolesBuilder() {
        }

        public UserRoles build() {
            this.checkUserRoles();
            return new UserRoles(this.roles.stream().collect(Collectors.toMap(r -> r, r -> this.users.stream().filter(User.userByRoleNamePredicate(r.name)).collect(Collectors.toCollection(LinkedHashSet::new)), (x, y) -> y, LinkedHashMap::new)));
        }

        private void checkUserRoles() {
            for (User user : this.users) {
                if (StringUtils.isBlank((CharSequence)user.roleName)) {
                    throw new IllegalArgumentException("Role declared for user [" + user.id + "] is blank");
                }
                Optional<Role> userRole = this.roles.stream().filter(Role.roleByNamePredicate(user.roleName)).findFirst();
                if (!userRole.isEmpty()) continue;
                throw new IllegalArgumentException("Role [" + user.roleName + "] declared for user [" + user.id + "] is not defined");
            }
        }

        public UserRolesBuilder withRoles(Collection<Role> roles) {
            if (Optional.ofNullable(roles).isPresent()) {
                this.roles = new LinkedHashSet<Role>(roles);
            }
            return this;
        }

        public UserRolesBuilder withUsers(Collection<User> users) {
            if (Optional.ofNullable(users).isPresent()) {
                this.users = new LinkedHashSet<User>(users);
            }
            return this;
        }
    }
}

