/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.server.core.domain.security;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class User {
    public static User ANONYMOUS = User.builder().build();
    public final String id;
    public final String roleName;

    private User(String id, String roleName) {
        this.id = id;
        this.roleName = roleName;
    }

    public static boolean isAnonymous(String userId) {
        return User.ANONYMOUS.id.equals(userId);
    }

    public static Predicate<User> userByRoleNamePredicate(String roleName) {
        return user -> user.roleName.equals(roleName);
    }

    public static Predicate<User> userByIdPredicate(String userId) {
        return user -> user.id.equals(userId);
    }

    public static UserBuilder builder() {
        return new UserBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return this.id.equals(user.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "User{id='" + this.id + "', role=" + this.roleName + "}";
    }

    public static class UserBuilder {
        private static final Predicate<String> USER_NAME_PREDICATE = Pattern.compile("^[\\w-]+$").asMatchPredicate();
        private static final String ANONYMOUS_USER_ID = "guest";
        private String id;
        private String role;

        private UserBuilder() {
        }

        public User build() {
            return new User(this.validateUserId(), Optional.ofNullable(this.role).orElse(""));
        }

        public UserBuilder withId(String id) {
            this.id = id;
            return this;
        }

        public UserBuilder withRole(String role) {
            this.role = role;
            return this;
        }

        private String validateUserId() {
            if (Optional.ofNullable(this.id).isEmpty()) {
                return ANONYMOUS_USER_ID;
            }
            if (!USER_NAME_PREDICATE.test(this.id)) {
                throw new IllegalArgumentException("User id must match the pattern `[0-9a-zA-Z_-]+`");
            }
            if (ANONYMOUS_USER_ID.equals(this.id)) {
                throw new IllegalArgumentException("User id [guest] cannot be used");
            }
            return this.id;
        }
    }
}

