/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.server.core.domain.tools;

import com.chutneytesting.server.core.domain.tools.PaginatedDto;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PaginatedDto", generator="Immutables")
@Immutable
public final class ImmutablePaginatedDto<PAGINATED_OBJECT>
implements PaginatedDto<PAGINATED_OBJECT> {
    private final long totalCount;
    private final List<PAGINATED_OBJECT> data;

    private ImmutablePaginatedDto(Builder<PAGINATED_OBJECT> builder) {
        this.totalCount = builder.totalCount;
        this.data = builder.dataIsSet() ? ImmutablePaginatedDto.createUnmodifiableList(true, builder.data) : ImmutablePaginatedDto.createUnmodifiableList(false, ImmutablePaginatedDto.createSafeList(PaginatedDto.super.data(), true, false));
    }

    private ImmutablePaginatedDto(long totalCount, List<PAGINATED_OBJECT> data) {
        this.totalCount = totalCount;
        this.data = data;
    }

    @Override
    @JsonProperty(value="totalCount")
    public long totalCount() {
        return this.totalCount;
    }

    @Override
    @JsonProperty(value="data")
    public List<PAGINATED_OBJECT> data() {
        return this.data;
    }

    public final ImmutablePaginatedDto<PAGINATED_OBJECT> withTotalCount(long value) {
        if (this.totalCount == value) {
            return this;
        }
        return new ImmutablePaginatedDto<PAGINATED_OBJECT>(value, this.data);
    }

    @SafeVarargs
    public final ImmutablePaginatedDto<PAGINATED_OBJECT> withData(PAGINATED_OBJECT ... elements) {
        List<PAGINATED_OBJECT> newValue = ImmutablePaginatedDto.createUnmodifiableList(false, ImmutablePaginatedDto.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePaginatedDto<PAGINATED_OBJECT>(this.totalCount, newValue);
    }

    public final ImmutablePaginatedDto<PAGINATED_OBJECT> withData(Iterable<? extends PAGINATED_OBJECT> elements) {
        if (this.data == elements) {
            return this;
        }
        List<? extends PAGINATED_OBJECT> newValue = ImmutablePaginatedDto.createUnmodifiableList(false, ImmutablePaginatedDto.createSafeList(elements, true, false));
        return new ImmutablePaginatedDto<PAGINATED_OBJECT>(this.totalCount, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePaginatedDto && this.equalTo(0, (ImmutablePaginatedDto)another);
    }

    private boolean equalTo(int synthetic, ImmutablePaginatedDto<?> another) {
        return this.totalCount == another.totalCount && this.data.equals(another.data);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.totalCount);
        h += (h << 5) + this.data.hashCode();
        return h;
    }

    public String toString() {
        return "PaginatedDto{totalCount=" + this.totalCount + ", data=" + this.data + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static <PAGINATED_OBJECT> ImmutablePaginatedDto<PAGINATED_OBJECT> fromJson(Json<PAGINATED_OBJECT> json) {
        Builder builder = ImmutablePaginatedDto.builder();
        if (json.totalCountIsSet) {
            builder.totalCount(json.totalCount);
        }
        if (json.dataIsSet) {
            builder.addAllData(json.data);
        }
        return builder.build();
    }

    public static <PAGINATED_OBJECT> ImmutablePaginatedDto<PAGINATED_OBJECT> copyOf(PaginatedDto<PAGINATED_OBJECT> instance) {
        if (instance instanceof ImmutablePaginatedDto) {
            return (ImmutablePaginatedDto)instance;
        }
        return ImmutablePaginatedDto.builder().from(instance).build();
    }

    public static <PAGINATED_OBJECT> Builder<PAGINATED_OBJECT> builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="PaginatedDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<PAGINATED_OBJECT> {
        private static final long INIT_BIT_TOTAL_COUNT = 1L;
        private static final long OPT_BIT_DATA = 1L;
        private long initBits = 1L;
        private long optBits;
        private long totalCount;
        private List<PAGINATED_OBJECT> data = new ArrayList<PAGINATED_OBJECT>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<PAGINATED_OBJECT> from(PaginatedDto<PAGINATED_OBJECT> instance) {
            Objects.requireNonNull(instance, "instance");
            this.totalCount(instance.totalCount());
            this.addAllData(instance.data());
            return this;
        }

        @JsonProperty(value="totalCount")
        @CanIgnoreReturnValue
        public final Builder<PAGINATED_OBJECT> totalCount(long totalCount) {
            this.totalCount = totalCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<PAGINATED_OBJECT> addData(PAGINATED_OBJECT element) {
            this.data.add(Objects.requireNonNull(element, "data element"));
            this.optBits |= 1L;
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder<PAGINATED_OBJECT> addData(PAGINATED_OBJECT ... elements) {
            for (PAGINATED_OBJECT element : elements) {
                this.data.add(Objects.requireNonNull(element, "data element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="data")
        @CanIgnoreReturnValue
        public final Builder<PAGINATED_OBJECT> data(Iterable<? extends PAGINATED_OBJECT> elements) {
            this.data.clear();
            return this.addAllData(elements);
        }

        @CanIgnoreReturnValue
        public final Builder<PAGINATED_OBJECT> addAllData(Iterable<? extends PAGINATED_OBJECT> elements) {
            for (PAGINATED_OBJECT element : elements) {
                this.data.add(Objects.requireNonNull(element, "data element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public ImmutablePaginatedDto<PAGINATED_OBJECT> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePaginatedDto(this);
        }

        private boolean dataIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("totalCount");
            }
            return "Cannot build PaginatedDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PaginatedDto", generator="Immutables")
    static final class Json<PAGINATED_OBJECT>
    implements PaginatedDto<PAGINATED_OBJECT> {
        long totalCount;
        boolean totalCountIsSet;
        @Nullable
        List<PAGINATED_OBJECT> data = Collections.emptyList();
        boolean dataIsSet;

        Json() {
        }

        @JsonProperty(value="totalCount")
        public void setTotalCount(long totalCount) {
            this.totalCount = totalCount;
            this.totalCountIsSet = true;
        }

        @JsonProperty(value="data")
        public void setData(List<PAGINATED_OBJECT> data) {
            this.data = data;
            this.dataIsSet = true;
        }

        @Override
        public long totalCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<PAGINATED_OBJECT> data() {
            throw new UnsupportedOperationException();
        }
    }
}

