/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.server.core.domain.dataset;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DataSet {
    public static Comparator<DataSet> datasetComparator = Comparator.comparing(DataSet::getName, String.CASE_INSENSITIVE_ORDER);
    public static DataSet NO_DATASET = DataSet.builder().build();
    public final String id;
    public final String name;
    public final String description;
    public final Instant creationDate;
    public final List<String> tags;
    public final Map<String, String> constants;
    public final List<Map<String, String>> datatable;

    private DataSet(String id, String name, String description, Instant creationDate, List<String> tags, Map<String, String> constants, List<Map<String, String>> datatable) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.creationDate = creationDate;
        this.tags = tags;
        this.constants = constants;
        this.datatable = datatable;
    }

    private String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSet dataSet = (DataSet)o;
        return Objects.equals(this.id, dataSet.id) && Objects.equals(this.name, dataSet.name) && Objects.equals(this.description, dataSet.description) && Objects.equals(this.creationDate, dataSet.creationDate) && Objects.equals(this.tags, dataSet.tags) && Objects.equals(this.constants, dataSet.constants) && Objects.equals(this.datatable, dataSet.datatable);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.creationDate, this.tags, this.constants, this.datatable);
    }

    public String toString() {
        return "DataSet{id='" + this.id + "', name='" + this.name + "', description='" + this.description + "', creationDate=" + this.creationDate + ", tags=" + this.tags + ", constants=" + this.constants + ", datatable=" + this.datatable + "}";
    }

    public static DataSetBuilder builder() {
        return new DataSetBuilder();
    }

    public static class DataSetBuilder {
        private static final String DEFAULT_ID = "-1";
        private String id;
        private String name;
        private String description;
        private Instant creationDate;
        private List<String> tags;
        private Map<String, String> constants;
        private List<Map<String, String>> datatable;

        private DataSetBuilder() {
        }

        public DataSet build() {
            if (!Objects.isNull(this.id) && this.id.isEmpty()) {
                throw new IllegalArgumentException("Dataset id cannot be empty");
            }
            return new DataSet(Optional.ofNullable(this.id).orElse(DEFAULT_ID), this.prettify(Optional.ofNullable(this.name).orElse("")), Optional.ofNullable(this.description).orElse(""), Optional.ofNullable(this.creationDate).orElseGet(() -> Instant.now().truncatedTo(ChronoUnit.MILLIS)), Optional.ofNullable(this.tags).orElse(Collections.emptyList()).stream().map(String::toUpperCase).map(String::strip).collect(Collectors.toList()), this.cleanConstants(Optional.ofNullable(this.constants).orElse(Collections.emptyMap())), this.cleanDatatable(Optional.ofNullable(this.datatable).orElse(Collections.emptyList())));
        }

        private String prettify(String name) {
            return name.strip().replaceAll(" +", " ");
        }

        public DataSetBuilder withId(String id) {
            this.id = id;
            return this;
        }

        public DataSetBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public DataSetBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        public DataSetBuilder withCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public DataSetBuilder withTags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public DataSetBuilder withConstants(Map<String, String> constants) {
            this.constants = constants;
            return this;
        }

        public DataSetBuilder withDatatable(List<Map<String, String>> datatable) {
            this.datatable = datatable;
            return this;
        }

        public DataSetBuilder fromDataSet(DataSet dataset) {
            return new DataSetBuilder().withId(dataset.id).withName(dataset.name).withDescription(dataset.description).withCreationDate(dataset.creationDate).withTags(dataset.tags).withConstants(dataset.constants).withDatatable(dataset.datatable);
        }

        private Map<String, String> cleanConstants(Map<String, String> constants) {
            return constants.entrySet().stream().filter(e -> StringUtils.isNotBlank((CharSequence)((CharSequence)e.getKey()))).collect(Collectors.toMap(e -> ((String)e.getKey()).trim(), e -> ((String)e.getValue()).trim()));
        }

        private List<Map<String, String>> cleanDatatable(List<Map<String, String>> datatable) {
            return datatable.stream().map(this::cleanConstants).filter(this::linesWithAtLeastOneNonBlankValue).map(m -> m.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).trim(), e -> ((String)e.getValue()).trim()))).collect(Collectors.toList());
        }

        private boolean linesWithAtLeastOneNonBlankValue(Map<String, String> map) {
            return map.values().stream().anyMatch(StringUtils::isNotBlank);
        }
    }
}

