/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.server.core.domain.execution.history;

import com.chutneytesting.server.core.domain.execution.history.HavingReport;
import com.chutneytesting.server.core.domain.execution.history.ImmutableExecutionHistory;
import com.chutneytesting.server.core.domain.execution.report.ServerReportStatus;
import com.chutneytesting.server.core.domain.scenario.campaign.CampaignExecutionReport;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableExecutionHistory.class)
@Value.Immutable
@Value.Enclosing
public interface ExecutionHistory {
    @Value.Parameter
    public String scenarioId();

    @Value.Parameter
    public List<Execution> history();

    @Value.Immutable
    public static interface Execution
    extends ExecutionProperties,
    HavingReport,
    Attached {
        default public ExecutionSummary summary() {
            return ImmutableExecutionHistory.ExecutionSummary.builder().from(this).from(this).build();
        }
    }

    @Value.Immutable
    public static interface ExecutionSummary
    extends ExecutionProperties,
    Attached {
    }

    @Value.Immutable
    public static interface DetachedExecution
    extends ExecutionProperties,
    HavingReport {
        default public Execution attach(long executionId) {
            return ImmutableExecutionHistory.Execution.builder().from(this).from(this).executionId(executionId).build();
        }
    }

    public static interface Attached {
        public Long executionId();
    }

    public static interface ExecutionProperties {
        public LocalDateTime time();

        public long duration();

        public ServerReportStatus status();

        public Optional<String> info();

        public Optional<String> error();

        public String testCaseTitle();

        public String environment();

        public Optional<String> datasetId();

        public Optional<Integer> datasetVersion();

        public String user();

        public Optional<CampaignExecutionReport> campaignReport();
    }
}

