/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.server.core.domain.tools.ui;

import com.chutneytesting.server.core.domain.tools.ui.ImmutableKeyValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableKeyValue.class)
@JsonDeserialize(as=ImmutableKeyValue.class)
@Value.Immutable
@Value.Style(jdkOnly=true)
public interface KeyValue {
    public String key();

    @Value.Default
    default public String value() {
        return "";
    }

    public static List<KeyValue> fromMap(Map<String, String> map) {
        return map.keySet().stream().map(key -> ImmutableKeyValue.builder().key((String)key).value((String)map.get(key)).build()).collect(Collectors.toList());
    }

    public static Map<String, String> toMap(List<KeyValue> list) {
        return Optional.ofNullable(list).map(l -> l.stream().filter(kv -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{kv.key()})).collect(Collectors.toMap(KeyValue::key, KeyValue::value, (k1, k2) -> k1, LinkedHashMap::new))).orElseGet(LinkedHashMap::new);
    }
}

