/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.server.core.domain.tools;

import com.chutneytesting.server.core.domain.tools.SortRequestParametersDto;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SortRequestParametersDto", generator="Immutables")
@Immutable
public final class ImmutableSortRequestParametersDto
implements SortRequestParametersDto {
    @Nullable
    private final String sort;
    @Nullable
    private final String desc;
    private final transient List<String> sortParameters;
    private final transient List<String> descParameters;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSortRequestParametersDto(@Nullable String sort, @Nullable String desc) {
        this.sort = sort;
        this.desc = desc;
        this.sortParameters = this.initShim.sortParameters();
        this.descParameters = this.initShim.descParameters();
        this.initShim = null;
    }

    private List<String> sortParametersInitialize() {
        return SortRequestParametersDto.super.sortParameters();
    }

    private List<String> descParametersInitialize() {
        return SortRequestParametersDto.super.descParameters();
    }

    @Override
    @JsonProperty(value="sort")
    @Nullable
    public String sort() {
        return this.sort;
    }

    @Override
    @JsonProperty(value="desc")
    @Nullable
    public String desc() {
        return this.desc;
    }

    @Override
    @JsonProperty(value="sortParameters")
    public List<String> sortParameters() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sortParameters() : this.sortParameters;
    }

    @Override
    @JsonProperty(value="descParameters")
    public List<String> descParameters() {
        InitShim shim = this.initShim;
        return shim != null ? shim.descParameters() : this.descParameters;
    }

    public final ImmutableSortRequestParametersDto withSort(@Nullable String value) {
        if (Objects.equals(this.sort, value)) {
            return this;
        }
        return new ImmutableSortRequestParametersDto(value, this.desc);
    }

    public final ImmutableSortRequestParametersDto withDesc(@Nullable String value) {
        if (Objects.equals(this.desc, value)) {
            return this;
        }
        return new ImmutableSortRequestParametersDto(this.sort, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSortRequestParametersDto && this.equalTo(0, (ImmutableSortRequestParametersDto)another);
    }

    private boolean equalTo(int synthetic, ImmutableSortRequestParametersDto another) {
        return Objects.equals(this.sort, another.sort) && Objects.equals(this.desc, another.desc) && this.sortParameters.equals(another.sortParameters) && this.descParameters.equals(another.descParameters);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.sort);
        h += (h << 5) + Objects.hashCode(this.desc);
        h += (h << 5) + this.sortParameters.hashCode();
        h += (h << 5) + this.descParameters.hashCode();
        return h;
    }

    public String toString() {
        return "SortRequestParametersDto{sort=" + this.sort + ", desc=" + this.desc + ", sortParameters=" + this.sortParameters + ", descParameters=" + this.descParameters + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSortRequestParametersDto fromJson(Json json) {
        Builder builder = ImmutableSortRequestParametersDto.builder();
        if (json.sort != null) {
            builder.sort(json.sort);
        }
        if (json.desc != null) {
            builder.desc(json.desc);
        }
        return builder.build();
    }

    public static ImmutableSortRequestParametersDto copyOf(SortRequestParametersDto instance) {
        if (instance instanceof ImmutableSortRequestParametersDto) {
            return (ImmutableSortRequestParametersDto)instance;
        }
        return ImmutableSortRequestParametersDto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SortRequestParametersDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String sort;
        @Nullable
        private String desc;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SortRequestParametersDto instance) {
            String descValue;
            Objects.requireNonNull(instance, "instance");
            String sortValue = instance.sort();
            if (sortValue != null) {
                this.sort(sortValue);
            }
            if ((descValue = instance.desc()) != null) {
                this.desc(descValue);
            }
            return this;
        }

        @JsonProperty(value="sort")
        @CanIgnoreReturnValue
        public final Builder sort(@Nullable String sort) {
            this.sort = sort;
            return this;
        }

        @JsonProperty(value="desc")
        @CanIgnoreReturnValue
        public final Builder desc(@Nullable String desc) {
            this.desc = desc;
            return this;
        }

        public ImmutableSortRequestParametersDto build() {
            return new ImmutableSortRequestParametersDto(this.sort, this.desc);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SortRequestParametersDto", generator="Immutables")
    static final class Json
    implements SortRequestParametersDto {
        @Nullable
        String sort;
        @Nullable
        String desc;

        Json() {
        }

        @JsonProperty(value="sort")
        public void setSort(@Nullable String sort) {
            this.sort = sort;
        }

        @JsonProperty(value="desc")
        public void setDesc(@Nullable String desc) {
            this.desc = desc;
        }

        @Override
        public String sort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String desc() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public List<String> sortParameters() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public List<String> descParameters() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="SortRequestParametersDto", generator="Immutables")
    private final class InitShim {
        private byte sortParametersBuildStage = 0;
        private List<String> sortParameters;
        private byte descParametersBuildStage = 0;
        private List<String> descParameters;

        private InitShim() {
        }

        List<String> sortParameters() {
            if (this.sortParametersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sortParametersBuildStage == 0) {
                this.sortParametersBuildStage = (byte)-1;
                this.sortParameters = Objects.requireNonNull(ImmutableSortRequestParametersDto.this.sortParametersInitialize(), "sortParameters");
                this.sortParametersBuildStage = 1;
            }
            return this.sortParameters;
        }

        List<String> descParameters() {
            if (this.descParametersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.descParametersBuildStage == 0) {
                this.descParametersBuildStage = (byte)-1;
                this.descParameters = Objects.requireNonNull(ImmutableSortRequestParametersDto.this.descParametersInitialize(), "descParameters");
                this.descParametersBuildStage = 1;
            }
            return this.descParameters;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sortParametersBuildStage == -1) {
                attributes.add("sortParameters");
            }
            if (this.descParametersBuildStage == -1) {
                attributes.add("descParameters");
            }
            return "Cannot build SortRequestParametersDto, attribute initializers form cycle " + attributes;
        }
    }
}

