/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.environment.infra;

import com.chutneytesting.environment.domain.Environment;
import com.chutneytesting.environment.domain.EnvironmentVariable;
import com.chutneytesting.environment.domain.Target;
import com.chutneytesting.environment.infra.JsonEnvVariable;
import com.chutneytesting.environment.infra.JsonEnvVariableMapper;
import com.chutneytesting.environment.infra.JsonTarget;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class JsonEnvironment {
    public String name;
    public String description;
    public Set<JsonTarget> targets;
    public Set<JsonEnvVariable> variables;

    public JsonEnvironment() {
    }

    private JsonEnvironment(String name, String description, Set<JsonTarget> targets, Set<JsonEnvVariable> variables) {
        this.name = name;
        this.description = description;
        this.targets = targets;
        this.variables = variables;
    }

    public static JsonEnvironment from(Environment environment) {
        Set<JsonTarget> targets = environment.targets.stream().map(JsonTarget::from).collect(Collectors.toSet());
        Set<JsonEnvVariable> variables = JsonEnvVariableMapper.INSTANCE.fromDomains(environment.variables);
        return new JsonEnvironment(environment.name, environment.description, targets, variables);
    }

    public Environment toEnvironment() {
        Set<EnvironmentVariable> variables = Optional.ofNullable(this.variables).orElse(Collections.emptySet()).stream().map(item -> JsonEnvVariableMapper.INSTANCE.toDomain((JsonEnvVariable)item, this.name)).collect(Collectors.toSet());
        Set<Target> targets = Optional.ofNullable(this.targets).orElse(Collections.emptySet()).stream().map(t -> t.toTarget(this.name)).collect(Collectors.toSet());
        return Environment.builder().withName(this.name).withDescription(this.description).withTargets(targets).withVariables(variables).build();
    }
}

