/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.environment.api.environment;

import com.chutneytesting.environment.api.environment.EnvironmentApi;
import com.chutneytesting.environment.api.environment.dto.EnvironmentDto;
import com.chutneytesting.environment.domain.exception.AlreadyExistingEnvironmentException;
import com.chutneytesting.environment.domain.exception.CannotDeleteEnvironmentException;
import com.chutneytesting.environment.domain.exception.EnvironmentNotFoundException;
import com.chutneytesting.environment.domain.exception.InvalidEnvironmentNameException;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.Set;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/api/v2/environments"})
public class HttpEnvironmentApi
implements EnvironmentApi {
    private final EnvironmentApi delegate;
    private final ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules().enable(SerializationFeature.INDENT_OUTPUT).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);

    HttpEnvironmentApi(EnvironmentApi delegate) {
        this.delegate = delegate;
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @GetMapping(produces={"application/json"})
    public Set<EnvironmentDto> listEnvironments() {
        return this.delegate.listEnvironments();
    }

    @Override
    @PreAuthorize(value="hasAuthority('SCENARIO_EXECUTE') or hasAuthority('CAMPAIGN_WRITE') or hasAuthority('CAMPAIGN_EXECUTE')")
    @GetMapping(path={"/names"}, produces={"application/json"})
    public Set<String> listEnvironmentsNames() {
        return this.delegate.listEnvironmentsNames();
    }

    @Override
    public String defaultEnvironmentName() {
        throw new UnsupportedOperationException();
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @PostMapping(consumes={"application/json"})
    public EnvironmentDto createEnvironment(@RequestBody EnvironmentDto environmentDto) throws InvalidEnvironmentNameException, AlreadyExistingEnvironmentException {
        return this.delegate.createEnvironment(environmentDto, false);
    }

    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @PostMapping(consumes={"multipart/form-data"})
    public EnvironmentDto importEnvironment(@RequestParam(value="file") MultipartFile file) {
        try {
            return this.importEnvironment((EnvironmentDto)this.objectMapper.readValue(file.getBytes(), EnvironmentDto.class));
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Cannot deserialize file: " + file.getName(), e);
        }
    }

    @Override
    public EnvironmentDto importEnvironment(EnvironmentDto environmentDto) {
        return this.delegate.importEnvironment(environmentDto);
    }

    @Override
    public EnvironmentDto createEnvironment(@RequestBody EnvironmentDto environmentDto, boolean force) {
        throw new UnsupportedOperationException();
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @DeleteMapping(value={"/{environmentName}"})
    public void deleteEnvironment(@PathVariable(value="environmentName") String environmentName) throws EnvironmentNotFoundException, CannotDeleteEnvironmentException {
        this.delegate.deleteEnvironment(environmentName);
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @PutMapping(value={"/{environmentName}"})
    public void updateEnvironment(@PathVariable(value="environmentName") String environmentName, @RequestBody EnvironmentDto environmentDto) throws InvalidEnvironmentNameException, EnvironmentNotFoundException {
        this.delegate.updateEnvironment(environmentName, environmentDto);
    }

    @Override
    @PreAuthorize(value="hasAuthority('ENVIRONMENT_ACCESS')")
    @GetMapping(value={"/{environmentName}"})
    public EnvironmentDto getEnvironment(@PathVariable(value="environmentName") String environmentName) throws EnvironmentNotFoundException {
        return this.delegate.getEnvironment(environmentName);
    }
}

