/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.environment.domain;

import com.chutneytesting.environment.domain.Target;
import com.chutneytesting.environment.domain.exception.AlreadyExistingTargetException;
import com.chutneytesting.environment.domain.exception.TargetNotFoundException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class Environment {
    public final String name;
    public final String description;
    public final Set<Target> targets;

    private Environment(String name, String description, Set<Target> targets) {
        this.name = name;
        this.description = description;
        this.targets = targets;
    }

    public static EnvironmentBuilder builder() {
        return new EnvironmentBuilder();
    }

    Environment addTarget(Target target) {
        if (this.containsTarget(target)) {
            throw new AlreadyExistingTargetException("Target [" + target.name + "] already exists in [" + this.name + "] environment");
        }
        return Environment.builder().from(this).addTarget(target).build();
    }

    private boolean containsTarget(Target target) {
        return this.targets.stream().anyMatch(t -> t.name.equalsIgnoreCase(target.name));
    }

    Target getTarget(String targetName) {
        return this.targets.stream().filter(t -> t.name.equals(targetName)).findFirst().orElseThrow(() -> new TargetNotFoundException("Target [" + targetName + "] not found in environment [" + this.name + "]"));
    }

    Environment deleteTarget(String targetName) {
        Optional<Target> targetToRemove = this.targets.stream().filter(t -> t.name.equals(targetName)).findFirst();
        return targetToRemove.map(t -> {
            HashSet<Target> updatedTargets = new HashSet<Target>(this.targets);
            updatedTargets.remove(t);
            return Environment.builder().from(this).withTargets(updatedTargets).build();
        }).orElseThrow(() -> new TargetNotFoundException("Target [" + targetName + "] not found in environment [" + this.name + "]"));
    }

    Environment updateTarget(String targetName, Target targetToUpdate) {
        Optional<Target> previousTarget = this.targets.stream().filter(t -> t.name.equals(targetName)).findFirst();
        return previousTarget.map(t -> {
            if (((Target)previousTarget.get()).equals(targetToUpdate)) {
                return this;
            }
            HashSet<Target> updatedTargets = new HashSet<Target>(this.targets);
            updatedTargets.remove(t);
            updatedTargets.add(targetToUpdate);
            return Environment.builder().from(this).withTargets(updatedTargets).build();
        }).orElseThrow(() -> new TargetNotFoundException("Target [" + targetName + "] not found in environment [" + this.name + "]"));
    }

    public String toString() {
        return "Environment{name='" + this.name + "', description='" + this.description + "', targets=" + this.targets + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Environment that = (Environment)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.targets, that.targets);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.targets);
    }

    public static class EnvironmentBuilder {
        private String name;
        private String description;
        private Set<Target> targets = new HashSet<Target>();

        private EnvironmentBuilder() {
        }

        public Environment build() {
            return new Environment(Optional.ofNullable(this.name).orElse(""), Optional.ofNullable(this.description).orElse(""), Optional.ofNullable(this.targets).map(Collections::unmodifiableSet).orElse(Collections.emptySet()));
        }

        public EnvironmentBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public EnvironmentBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        public EnvironmentBuilder withTargets(Set<Target> targetSet) {
            this.targets = new HashSet<Target>(targetSet);
            return this;
        }

        public EnvironmentBuilder addTarget(Target target) {
            this.targets.add(target);
            return this;
        }

        public EnvironmentBuilder addAllTargets(List<Target> targets) {
            this.targets.addAll(targets);
            return this;
        }

        public EnvironmentBuilder from(Environment environment) {
            this.name = environment.name;
            this.description = environment.description;
            this.targets = new HashSet<Target>(environment.targets);
            return this;
        }
    }
}

