/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.environment;

import com.chutneytesting.environment.api.EmbeddedEnvironmentApi;
import com.chutneytesting.environment.domain.Environment;
import com.chutneytesting.environment.domain.EnvironmentRepository;
import com.chutneytesting.environment.domain.EnvironmentService;
import com.chutneytesting.environment.infra.JsonFilesEnvironmentRepository;

public class EnvironmentConfiguration {
    private final EnvironmentRepository environmentRepository;
    private final EmbeddedEnvironmentApi environmentApi;

    public EnvironmentConfiguration(String storeFolderPath) {
        this.environmentRepository = this.createEnvironmentRepository(storeFolderPath);
        EnvironmentService environmentService = this.createEnvironmentService(this.environmentRepository);
        this.environmentApi = new EmbeddedEnvironmentApi(environmentService);
        this.createDefaultEnvironment(environmentService);
    }

    private void createDefaultEnvironment(EnvironmentService environmentService) {
        if (this.environmentRepository.listNames().isEmpty()) {
            environmentService.createEnvironment(Environment.builder().withName("DEFAULT").build());
        }
    }

    private EnvironmentRepository createEnvironmentRepository(String storeFolderPath) {
        return new JsonFilesEnvironmentRepository(storeFolderPath);
    }

    private EnvironmentService createEnvironmentService(EnvironmentRepository environmentRepository) {
        return new EnvironmentService(environmentRepository);
    }

    public EmbeddedEnvironmentApi getEmbeddedEnvironmentApi() {
        return this.environmentApi;
    }
}

