/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.environment.api.dto;

import com.chutneytesting.environment.api.dto.TargetDto;
import com.chutneytesting.environment.domain.Environment;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class EnvironmentDto {
    public String name;
    public String description;
    public List<TargetDto> targets;

    public static EnvironmentDto from(Environment environment) {
        EnvironmentDto environmentMetadataDto = new EnvironmentDto();
        environmentMetadataDto.name = environment.name;
        environmentMetadataDto.description = environment.description;
        environmentMetadataDto.targets = environment.targets.stream().map(TargetDto::from).collect(Collectors.toList());
        return environmentMetadataDto;
    }

    public Environment toEnvironment() {
        return Environment.builder().withName(this.name).withDescription(this.description).withTargets(Optional.ofNullable(this.targets).orElse(Collections.emptyList()).stream().map(t -> t.toTarget(this.name)).collect(Collectors.toSet())).build();
    }
}

