/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.delegation;

import com.chutneytesting.action.spi.injectable.Target;
import com.chutneytesting.engine.domain.delegation.DelegationClient;
import com.chutneytesting.engine.domain.delegation.NamedHostAndPort;
import com.chutneytesting.engine.domain.delegation.RemoteStepExecutor;
import com.chutneytesting.engine.domain.environment.TargetImpl;
import com.chutneytesting.engine.domain.execution.engine.StepExecutor;
import java.util.List;
import java.util.Optional;

public class DelegationService {
    private final StepExecutor localStepExecutor;
    private final DelegationClient delegationClient;

    public DelegationService(StepExecutor localStepExecutor, DelegationClient delegationClient) {
        this.localStepExecutor = localStepExecutor;
        this.delegationClient = delegationClient;
    }

    public StepExecutor findExecutor(Optional<Target> target) {
        if (target.isEmpty() || target.get().name().isEmpty()) {
            return this.localStepExecutor;
        }
        List<NamedHostAndPort> agents = ((TargetImpl)target.get()).agents;
        if (!agents.isEmpty()) {
            NamedHostAndPort nextAgent = agents.get(0);
            agents.remove(0);
            return new RemoteStepExecutor(this.delegationClient, nextAgent);
        }
        return this.localStepExecutor;
    }
}

