/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.execution.strategies;

import com.chutneytesting.engine.domain.execution.ScenarioExecution;
import com.chutneytesting.engine.domain.execution.engine.evaluation.EvaluationException;
import com.chutneytesting.engine.domain.execution.engine.evaluation.StepDataEvaluator;
import com.chutneytesting.engine.domain.execution.engine.scenario.ScenarioContext;
import com.chutneytesting.engine.domain.execution.engine.step.Step;
import com.chutneytesting.engine.domain.execution.report.Status;
import com.chutneytesting.engine.domain.execution.strategies.DefaultStepExecutionStrategy;
import com.chutneytesting.engine.domain.execution.strategies.StepExecutionStrategies;
import com.chutneytesting.engine.domain.execution.strategies.StepExecutionStrategy;
import com.chutneytesting.engine.domain.execution.strategies.StepStrategyDefinition;
import java.util.Map;

public class IfStrategy
implements StepExecutionStrategy {
    private static final String TYPE = "if";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Status execute(ScenarioExecution scenarioExecution, Step step, ScenarioContext scenarioContext, Map<String, Object> localContext, StepExecutionStrategies strategies) {
        StepStrategyDefinition strategyDefinition = step.strategy().orElseThrow(() -> new IllegalArgumentException("Strategy definition cannot be empty"));
        Object conditionObject = strategyDefinition.strategyProperties.getProperty("condition", Object.class);
        if (conditionObject == null) {
            throw new IllegalArgumentException("Property [condition] mandatory for if strategy");
        }
        Boolean condition = IfStrategy.getCondition(scenarioContext, conditionObject, step.dataEvaluator());
        String conditionStatus = condition != false ? "step executed" : "step skipped";
        step.addInformation("Execution condition [" + conditionObject + "] = " + conditionStatus);
        if (condition.booleanValue()) {
            return DefaultStepExecutionStrategy.instance.execute(scenarioExecution, step, scenarioContext, localContext, strategies);
        }
        step.success(new String[0]);
        this.skipAllSubSteps(step);
        return Status.SUCCESS;
    }

    private void skipAllSubSteps(Step step) {
        if (step.isParentStep()) {
            step.subSteps().forEach(subStep -> {
                subStep.addInformation("Step skipped");
                subStep.success(new String[0]);
                this.skipAllSubSteps((Step)subStep);
            });
        }
    }

    private static Boolean getCondition(ScenarioContext scenarioContext, Object conditionObject, StepDataEvaluator evaluator) {
        if (conditionObject instanceof Boolean) {
            Boolean booleanCondition = (Boolean)conditionObject;
            return booleanCondition;
        }
        if (conditionObject instanceof String) {
            String stringCondition = (String)conditionObject;
            try {
                return (Boolean)evaluator.evaluate(stringCondition, scenarioContext);
            }
            catch (EvaluationException | ClassCastException e) {
                throw new RuntimeException("Cannot evaluate execution condition: [" + conditionObject + "]. Error message: " + e.getMessage());
            }
        }
        throw new RuntimeException("Cannot evaluate execution condition: [" + conditionObject + "]. should be a boolean or a Spring Expression Language which return a boolean");
    }
}

