/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.execution.engine.parameterResolver;

import com.chutneytesting.action.spi.injectable.Logger;
import java.util.function.Consumer;
import org.slf4j.LoggerFactory;

public class DelegateLogger
implements Logger {
    private final Consumer<String> infoConsumer;
    private final Consumer<String> errorConsumer;
    private static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger(DelegateLogger.class);
    private final Logger reportOnly = new ReportLogger();

    public DelegateLogger(Consumer<String> infoConsumer, Consumer<String> errorConsumer) {
        this.infoConsumer = infoConsumer;
        this.errorConsumer = errorConsumer;
    }

    public void info(String message) {
        this.infoConsumer.accept(message);
        LOGGER.debug(message);
    }

    public void error(String message) {
        this.errorConsumer.accept(message);
        LOGGER.debug(message);
    }

    public void error(Throwable exception) {
        this.errorConsumer.accept(exception.getMessage());
        LOGGER.debug(exception.getMessage(), exception);
    }

    public Logger reportOnly() {
        return this.reportOnly;
    }

    private class ReportLogger
    implements Logger {
        private ReportLogger() {
        }

        public void info(String message) {
            DelegateLogger.this.infoConsumer.accept(message);
        }

        public void error(String message) {
            DelegateLogger.this.errorConsumer.accept(message);
        }

        public void error(Throwable exception) {
            DelegateLogger.this.errorConsumer.accept(exception.getMessage());
        }

        public Logger reportOnly() {
            return this;
        }
    }
}

