/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.engine.domain.execution.engine.parameterResolver;

import com.chutneytesting.action.domain.parameter.Parameter;
import com.chutneytesting.action.domain.parameter.ParameterResolver;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.engine.domain.execution.engine.parameterResolver.InputNameMandatoryException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;

public class InputParameterResolver
implements ParameterResolver {
    private final Map<String, Object> inputs;
    private static final Map<Class<?>, Function<String, ?>> primitivesValueOf = new HashMap();

    public InputParameterResolver(Map<String, Object> inputs) {
        this.inputs = inputs;
    }

    @Override
    public boolean canResolve(Parameter parameter) {
        return parameter.annotations().optional(Input.class).isPresent();
    }

    @Override
    public Object resolve(Parameter parameter) {
        Object inputResolution;
        boolean isParameterPrimitive = ClassUtils.isPrimitiveOrWrapper(parameter.rawType());
        String inputName = this.getValidParameter(parameter);
        Object inputValue = this.inputs.get(inputName);
        if (inputValue == null) {
            if (isParameterPrimitive) {
                return null;
            }
            Optional<Object> valueInstantiate = this.createObjectFromInputs(this.inputs, parameter.rawType());
            return valueInstantiate.orElse(null);
        }
        Class<?> inputClassType = inputValue.getClass();
        if (parameter.rawType().isAssignableFrom(inputClassType)) {
            return inputValue;
        }
        if (parameter.rawType().equals(String.class)) {
            if (ClassUtils.isPrimitiveOrWrapper(inputClassType)) {
                return inputValue.toString();
            }
            if (inputValue instanceof Map) {
                Map map = (Map)inputValue;
                return new JSONObject(map).toString();
            }
        } else if (inputClassType.equals(String.class) && (inputResolution = this.valueOf(parameter.rawType(), (String)inputValue)) != null) {
            return inputResolution;
        }
        throw new IllegalArgumentException(inputName + " type is " + inputClassType + ", should be " + parameter.rawType());
    }

    private Object valueOf(Class<?> clazz, String inputValue) {
        return Optional.ofNullable(primitivesValueOf.get(clazz)).map(m -> m.apply(inputValue)).orElse(null);
    }

    private String getValidParameter(Parameter parameter) {
        Input input = parameter.annotations().get(Input.class);
        String inputName = input.value();
        if (StringUtils.isEmpty((CharSequence)inputName)) {
            throw new InputNameMandatoryException();
        }
        return inputName;
    }

    private Optional<Object> createObjectFromInputs(Map<String, Object> inputs, Class<?> aClass) {
        Constructor<?>[] constructors = aClass.getConstructors();
        if (constructors.length == 1) {
            Constructor<?> constructor = constructors[0];
            List<Object> parameters = Arrays.stream(constructor.getParameters()).map(p -> {
                String inputName = this.getValidParameter(Parameter.fromJavaParameter(p));
                return inputs.get(inputName);
            }).toList();
            try {
                return Optional.of(constructor.newInstance(parameters.toArray()));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return Optional.empty();
    }

    private static Character characterValueOf(String s) {
        if (s == null) {
            throw new IllegalArgumentException("null");
        }
        if (s.isEmpty()) {
            throw new IllegalArgumentException("empty");
        }
        return Character.valueOf(s.charAt(0));
    }

    static {
        primitivesValueOf.put(Short.class, Short::valueOf);
        primitivesValueOf.put(Integer.class, Integer::valueOf);
        primitivesValueOf.put(Long.class, Long::valueOf);
        primitivesValueOf.put(Boolean.class, Boolean::valueOf);
        primitivesValueOf.put(Character.class, InputParameterResolver::characterValueOf);
        primitivesValueOf.put(Float.class, Float::valueOf);
        primitivesValueOf.put(Double.class, Double::valueOf);
        primitivesValueOf.put(Byte.class, Byte::valueOf);
    }
}

