/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.action.api;

import com.chutneytesting.action.api.ActionDto;
import com.chutneytesting.action.domain.ActionTemplate;
import com.chutneytesting.action.domain.parameter.Parameter;
import com.chutneytesting.action.spi.injectable.Input;
import com.chutneytesting.action.spi.injectable.Target;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ActionTemplateMapper {
    private ActionTemplateMapper() {
    }

    public static ActionDto toDto(ActionTemplate actionTemplate) {
        return new ActionDto(actionTemplate.identifier(), ActionTemplateMapper.hasTarget(actionTemplate), ActionTemplateMapper.toInputsDto(actionTemplate));
    }

    private static boolean hasTarget(ActionTemplate actionTemplate) {
        return actionTemplate.parameters().stream().anyMatch(p -> p.rawType().equals(Target.class));
    }

    private static List<ActionDto.InputsDto> toInputsDto(ActionTemplate actionTemplate) {
        Map<Boolean, List<Parameter>> parametersMap = actionTemplate.parameters().stream().filter(parameter -> parameter.annotations().optional(Input.class).isPresent()).collect(Collectors.partitioningBy(ActionTemplateMapper::isSimpleType));
        return Stream.concat(parametersMap.get(true).stream().map(ActionTemplateMapper::simpleParameterToInputsDto), parametersMap.get(false).stream().map(ActionTemplateMapper::complexParameterToInputsDto).flatMap(Collection::stream)).collect(Collectors.toList());
    }

    private static ActionDto.InputsDto simpleParameterToInputsDto(Parameter parameter) {
        return new ActionDto.InputsDto(parameter.annotations().get(Input.class).value(), parameter.rawType());
    }

    private static List<ActionDto.InputsDto> complexParameterToInputsDto(Parameter parameter) {
        Constructor<?> constructor;
        List<ActionDto.InputsDto> result;
        Constructor<?>[] constructors = parameter.rawType().getConstructors();
        if (constructors.length == 1 && !(result = Arrays.stream((constructor = constructors[0]).getParameters()).map(Parameter::fromJavaParameter).filter(p -> p.annotations().optional(Input.class).isPresent()).map(p -> new ActionDto.InputsDto(p.annotations().get(Input.class).value(), p.rawType())).collect(Collectors.toList())).isEmpty()) {
            return result;
        }
        return Collections.singletonList(ActionTemplateMapper.simpleParameterToInputsDto(parameter));
    }

    private static boolean isSimpleType(Parameter parameter) {
        Class<?> rawType = parameter.rawType();
        return rawType.isPrimitive() || rawType.equals(String.class) || rawType.equals(Object.class);
    }
}

